//Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
//Cleversafe Dispersed Storage(TM) is software for secure, private and
//reliable storage of the world's data using information dispersal.
//
//Copyright (C) 2005-2007 Cleversafe, Inc.
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
//USA.
//
//Contact Information: 
// Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email: licensing@cleversafe.org
//
//END-OF-HEADER
//-----------------------
//@author: John Quigley <jquigley@cleversafe.com>
//@date: January 1, 2008
//---------------------

package org.jscsi.scsi.protocol.cdb;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

import org.jscsi.scsi.protocol.util.ByteBufferInputStream;

public class ModeSense10 extends ModeSense6
{
   public static final int OPERATION_CODE = 0x5A;

   private boolean LLBAA;

   public ModeSense10()
   {
      super(OPERATION_CODE);
   }

   public ModeSense10(
         boolean dbd,
         boolean llbaa,
         int pageControl,
         int pageCode,
         int subPageCode,
         boolean linked,
         boolean normalACA,
         long allocationLength)
   {
      super(dbd, pageControl, pageCode, subPageCode, linked, normalACA, allocationLength);

      this.LLBAA = llbaa;
   }

   public ModeSense10(
         boolean dbd,
         boolean llbaa,
         int pageControl,
         int pageCode,
         int subPageCode,
         long allocationLength)
   {
      this(dbd, llbaa, pageControl, pageCode, subPageCode, false, false, allocationLength);
   }

   public void decode(byte[] header, ByteBuffer input) throws IOException
   {
      DataInputStream in = new DataInputStream(new ByteBufferInputStream(input));
      int tmp;

      int operationCode = in.readUnsignedByte();
      tmp = in.readUnsignedByte();
      this.setDBD((tmp & 0x08) != 0);
      tmp >>>= 4;
      this.LLBAA = (tmp & 0x01) != 0;
      tmp = in.readUnsignedByte();
      this.setPageCode(tmp & 0x3F);
      this.setPC(tmp >>> 6);
      this.setSubPageCode(in.readUnsignedByte());
      in.readShort(); // first part of RESERVED block
      in.readByte(); // remaining RESERVED block
      setAllocationLength(in.readUnsignedShort());

      super.setControl(in.readUnsignedByte());

      if (operationCode != OPERATION_CODE)
      {
         throw new IOException("Invalid operation code: " + Integer.toHexString(operationCode));
      }

   }

   public byte[] encode()
   {
      ByteArrayOutputStream cdb = new ByteArrayOutputStream(this.size());
      DataOutputStream out = new DataOutputStream(cdb);

      try
      {
         out.writeByte(OPERATION_CODE);
         out.writeByte(((this.LLBAA ? 0x10 : 0x00) | (this.isDBD() ? 0x08 : 0x00)));
         out.writeByte((this.getPC() << 6) | this.getPageCode());
         out.writeByte(this.getSubPageCode());
         out.writeShort(0);
         out.writeByte(0);
         out.writeShort((int) getAllocationLength());
         out.writeByte(super.getControl());

         return cdb.toByteArray();
      }
      catch (IOException e)
      {
         throw new RuntimeException("Unable to encode CDB.");
      }
   }

   public int size()
   {
      return 10;
   }

   public boolean isLLBAA()
   {
      return this.LLBAA;
   }

   public void setLLBAA(boolean llbaa)
   {
      this.LLBAA = llbaa;
   }
}
