//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: Srini Palthepu (spalthepu@cleversafe.com)
//
// Date: Nov 6, 2007
//---------------------

package org.cleversafe.layer.fileobj.jlanproto;

import java.util.List;

import org.cleversafe.codec.Codec;
import org.cleversafe.ida.InformationDispersalCodec;
import org.cleversafe.layer.slicestore.SliceStore;
import org.cleversafe.vault.BaseVault;

public class FileDeviceVault extends BaseVault
{
   //private static Logger _logger = Logger.getLogger(FileDeviceVault.class);

   /* Number of blocks in this vault */
   public static final String TYPE = "file";
   protected long maxFSSize;

   public FileDeviceVault()
   {
      super(TYPE);
   }

   /**
    * 
    * @param fsSize
    * @param idaCodec
    * @param codecs
    * @param sliceStores
    */
   public FileDeviceVault(
         final long fsSize,
         InformationDispersalCodec idaCodec,
         List<Codec> codecs,
         List<Codec> sliceCodecs,
         List<SliceStore> sliceStores)
   {
      super(TYPE, idaCodec, codecs, sliceCodecs, sliceStores);
      //TODO:: remove maxFSSize limit.
      this.maxFSSize = fsSize;
   }

   public long getSize()
   {
      return getMaxDeviceSize();
   }

   /**
    * Returns the maximum-size block device that can be created in this vault
    * 
    * @return long Maximum size of device that can fit into this vault
    */
   public long getMaxDeviceSize()
   {
      // FIXME: Calculate the size with num blocks, slice overhead, and coding
      // taken into account
      return this.maxFSSize;
   }

   // TODO: implement this properly
   public long getMaxSliceSize()
   {
      //return this.getSliceSize(blockSize);
      return 0;
   }

   // TODO: implement this properly
   @Override
   public long getSliceStoreSize(int sliceStoreIndex)
   {
      return 0;
   }

   public String toString()
   {
      StringBuffer buf = new StringBuffer();
      buf.append("FileDevice[").append((double) getMaxDeviceSize() / (1024 * 1024)).append("MB ] ");
      buf.append(super.toString());
      return buf.toString();
   }

   public void optimizeVault()
   {

      //_logger.error("Optimize .");
      System.out.println("Optimization not impilmented for File Vault.");
   }
}
