/*
 * Copyright (C) 2006-2007 Alfresco Software Limited.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

 * As a special exception to the terms and conditions of version 2.0 of 
 * the GPL, you may redistribute this Program in connection with Free/Libre 
 * and Open Source Software ("FLOSS") applications as described in Alfresco's 
 * FLOSS exception.  You should have recieved a copy of the text describing 
 * the FLOSS exception, and it is also available here: 
 * http://www.alfresco.com/legal/licensing"
 */

package org.alfresco.jlan.oncrpc;

import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.auth.ClientInfo;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.config.ConfigElement;


/**
 * RPC Authenticator Interface
 * 
 * <p>Provides authentication support for ONC/RPC requests.
 *
 * @author gkspencer
 */
public interface RpcAuthenticator {

	/**
	 * Initialize the RPC authenticator
	 * 
	 * @param config ServerConfiguration
	 * @param params ConfigElement
	 * @exception InvalidConfigurationException
	 */
	public void initialize(ServerConfiguration config, ConfigElement params)
		throws InvalidConfigurationException;
	
  /**
   * Authenticate an RPC client using the credentials within the RPC request. The object that is returned is
   * used as the key to find the associated session object.
   * 
   * @param authType int
   * @param rpc RpcPacket
   * @return Object
   * @exception RpcAuthenticationException
   */
  public Object authenticateRpcClient(int authType, RpcPacket rpc)
  	throws RpcAuthenticationException;

  /**
   * Get RPC client information from the RPC request.
   * 
   * <p>This method is called when a new session object is created by an RPC server.
   * 
   * @param sessKey Object
   * @param rpc RpcPacket
   * @return ClientInfo
   */
  public ClientInfo getRpcClientInformation(Object sessKey, RpcPacket rpc);
  
  /**
   * Return a list of the authentication types that the RPC authenticator implementation supports. The
   * authentication types are specified in the AuthType class.
   * 
   * @return int[]
   */
  public int[] getRpcAuthenticationTypes();
  
  /**
   * Set the current authenticated user context for processing of the current RPC request
   * 
   * @param sess SrvSession
   * @param client ClientInfo
   */
  public void setCurrentUser( SrvSession sess, ClientInfo client);
}
