//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: wleggette
//
// Date: May 31, 2007
//---------------------

package org.cleversafe.vault.util;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import java.io.IOException;
import java.util.UUID;

import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.cleversafe.util.ASN1UniqueIdentifier;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

// TODO: Describe class or interface
public class ASN1UniqueIdentifierTest
{
   @BeforeClass
   public static void setUpBeforeClass() throws Exception
   {
   }

   @AfterClass
   public static void tearDownAfterClass() throws Exception
   {
   }

   @Before
   public void setUp() throws Exception
   {
   }

   @After
   public void tearDown() throws Exception
   {
   }

   @Test
   public void testASN1UniqueIdentifierUUID() throws IOException
   {
      UUID uuid = UUID.randomUUID();
      ASN1UniqueIdentifier id = new ASN1UniqueIdentifier( uuid );
      
      assertEquals( uuid, id.getIdentifier() );
      
      DERObject asnObj = id.getDERObject();
      
      ASN1UniqueIdentifier rec = ASN1UniqueIdentifier.getInstance( asnObj );
      
      assertEquals( id, rec );
      assertEquals( uuid, rec.getIdentifier() );
      
      byte[] encoded = id.getDEREncoded();
      
      ASN1InputStream in = new ASN1InputStream( encoded );
      
      rec = ASN1UniqueIdentifier.getInstance( in.readObject() );
      
      try
      {
         DEROctetString shortstr = new DEROctetString( new byte[] { 12, 40, -35, 12 } );
         ASN1UniqueIdentifier.getInstance(shortstr);
         fail( "factory accepted invalid input octet string (was too short)" );
      }
      catch (IllegalArgumentException e) {}
      
   }

}


