//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: wleggette
//
// Date: Jun 18, 2007
//---------------------

package org.cleversafe.vault.storage.asn1;
import static org.junit.Assert.assertEquals;

import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.cleversafe.vault.storage.asn1.KeyUsage;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

// TODO: Describe class or interface
public class KeyUsageTest
{
   @BeforeClass
   public static void setUpBeforeClass() throws Exception
   {
   }

   @AfterClass
   public static void tearDownAfterClass() throws Exception
   {
   }

   @Before
   public void setUp() throws Exception
   {
   }

   @After
   public void tearDown() throws Exception
   {
   }

   @Test
   public void testGetInstance()
   {
      DERInteger intobj = new DERInteger(0);
      KeyUsage usage = KeyUsage.getInstance(intobj);
      assertEquals( KeyUsage.DATASOURCE_ENCRYPTION, usage );
      
      intobj = new DERInteger(1);
      usage = KeyUsage.getInstance(intobj);
      assertEquals( KeyUsage.DATASOURCE_VERIFICATION, usage );
      
      intobj = new DERInteger(2);
      usage = KeyUsage.getInstance(intobj);
      assertEquals( KeyUsage.SLICE_VERIFICATION, usage );
   }

   @Test
   public void testToASN1Object()
   {
      KeyUsage source = KeyUsage.DATASOURCE_ENCRYPTION;
      DERObject obj = source.getDERObject();
      KeyUsage dest = KeyUsage.getInstance(obj);
      assertEquals( source, dest );
      
      source = KeyUsage.DATASOURCE_VERIFICATION;
      obj = source.getDERObject();
      dest = KeyUsage.getInstance(obj);
      assertEquals( source, dest );
      
      source = KeyUsage.SLICE_VERIFICATION;
      obj = source.getDERObject();
      dest = KeyUsage.getInstance(obj);
      assertEquals( source, dest );
   }

}


