//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: wleggette
//
// Date: Feb 9, 2008
//---------------------

package org.cleversafe.vault.storage;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.cleversafe.test.BaseTest;
import org.cleversafe.vault.storage.asn1.KeyUsage;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class VaultKeyInfoGeneratorTest extends BaseTest
{
   private static Logger _logger = Logger.getLogger(VaultKeyInfoGeneratorTest.class);

   private static final String COMPAT_DESCRIPTOR_PATH = "compat";
   
   private static final String DESCRIPTOR_ALL_CODECS = "remote-local-all-codecs-vault-descriptor.xml";
   private static final String DESCRIPTOR_CRC = "remote-local-crc-vault-descriptor.xml";
   private static final String DESCRIPTOR_NORMAL = "remote-local-vault-descriptor.xml";
   
   @BeforeClass
   public static void setUpBeforeClass() throws Exception
   {
   }

   @AfterClass
   public static void tearDownAfterClass() throws Exception
   {
   }

   @Before
   public void setUp() throws Exception
   {
   }

   @After
   public void tearDown() throws Exception
   {
   }
   
   @Test
   public void testCompatAllCodecs() throws Exception
   {
      File input = new File(this.getInputDirectory() + File.separator + COMPAT_DESCRIPTOR_PATH +
            File.separator + DESCRIPTOR_ALL_CODECS);
      List<VaultKeyInfo> info = VaultKeyInfoGenerator.generate(new FileInputStream(input));
      System.out.println(info);
      
      List<VaultKeyInfo> expected = new ArrayList<VaultKeyInfo>();
      expected.add(new VaultKeyInfo(0, "DSA", 1024, KeyUsage.DATASOURCE_VERIFICATION));
      expected.add(new VaultKeyInfo(1, "AES", 128, KeyUsage.DATASOURCE_ENCRYPTION));
      expected.add(new VaultKeyInfo(2, "DSA", 1024, KeyUsage.SLICE_VERIFICATION));
      
      assertEquals("incorrect number of keyed codecs found", expected.size(), info.size());
      for (VaultKeyInfo i : expected)
      {
         System.out.println("looking for " + i);
         assertTrue("Expected vault key information not found", info.contains(i));
      }
   }
   
   @Test
   public void testCompatCRCCodec() throws Exception
   {
      File input = new File(this.getInputDirectory() + File.separator + COMPAT_DESCRIPTOR_PATH +
            File.separator + DESCRIPTOR_CRC);
      List<VaultKeyInfo> info = VaultKeyInfoGenerator.generate(new FileInputStream(input));
      System.out.println(info);
      
      assertEquals("incorrect number of keyed codecs found", 0, info.size());
   }
   

   @Test
   public void testCompatNormalCodecs() throws Exception
   {
      File input = new File(this.getInputDirectory() + File.separator + COMPAT_DESCRIPTOR_PATH +
            File.separator + DESCRIPTOR_NORMAL);
      List<VaultKeyInfo> info = VaultKeyInfoGenerator.generate(new FileInputStream(input));
      System.out.println(info);
      
      List<VaultKeyInfo> expected = new ArrayList<VaultKeyInfo>();
      expected.add(new VaultKeyInfo(1, "DSA", 1024, KeyUsage.SLICE_VERIFICATION));
      
      assertEquals("incorrect number of keyed codecs found", expected.size(), info.size());
      for (VaultKeyInfo i : expected)
      {
         System.out.println("looking for " + i);
         assertTrue("Expected vault key information not found", info.contains(i));
      }
   }
   

   @Test
   public void testAllCodecs() throws Exception
   {
      File input = new File(this.getInputDirectory() + File.separator + DESCRIPTOR_ALL_CODECS);
      List<VaultKeyInfo> info = VaultKeyInfoGenerator.generate(new FileInputStream(input));
      System.out.println(info);
      
      List<VaultKeyInfo> expected = new ArrayList<VaultKeyInfo>();
      expected.add(new VaultKeyInfo(0, "DSA", 1024, KeyUsage.DATASOURCE_VERIFICATION));
      expected.add(new VaultKeyInfo(2, "AES", 128, KeyUsage.DATASOURCE_ENCRYPTION));
      expected.add(new VaultKeyInfo(4, "DSA", 1024, KeyUsage.SLICE_VERIFICATION));
      
      assertEquals("incorrect number of keyed codecs found", expected.size(), info.size());
      for (VaultKeyInfo i : expected)
      {
         System.out.println("looking for " + i);
         assertTrue("Expected vault key information not found", info.contains(i));
      }
   }
   
   @Test
   public void testCRCCodec() throws Exception
   {
      File input = new File(this.getInputDirectory() + File.separator + DESCRIPTOR_CRC);
      List<VaultKeyInfo> info = VaultKeyInfoGenerator.generate(new FileInputStream(input));
      System.out.println(info);
      
      assertEquals("incorrect number of keyed codecs found", 0, info.size());
   }
   

   @Test
   public void testNormalCodecs() throws Exception
   {
      File input = new File(this.getInputDirectory() + File.separator + DESCRIPTOR_NORMAL);
      List<VaultKeyInfo> info = VaultKeyInfoGenerator.generate(new FileInputStream(input));
      System.out.println(info);
      
      List<VaultKeyInfo> expected = new ArrayList<VaultKeyInfo>();
      expected.add(new VaultKeyInfo(0, "DSA", 1024, KeyUsage.SLICE_VERIFICATION));
      
      assertEquals("incorrect number of keyed codecs found", expected.size(), info.size());
      for (VaultKeyInfo i : expected)
      {
         System.out.println("looking for " + i);
         assertTrue("Expected vault key information not found", info.contains(i));
      }
   }
   
   

}


