//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: mmotwani
//
// Date: Feb 7, 2008
//---------------------

package org.cleversafe.util;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

// TODO: Describe class or interface
public class VersionTest
{
   @Test
   public void testVersionStringStringString()
   {
      Version version = new Version("1", "4", "3");

      assertEquals(version.toString(), "1.4.3");
      assertEquals(version.getMajor(), "1");
      assertEquals(version.getMinor(), "4");
      assertEquals(version.getBuild(), "3");
   }

   @Test
   public void testFromString()
   {
      Version version = Version.fromString("1.4.3");
      assertEquals(version.toString(), "1.4.3");
      assertEquals(version.getMajor(), "1");
      assertEquals(version.getMinor(), "4");
      assertEquals(version.getBuild(), "3");

      Version version2 = Version.fromString("10.08");
      assertEquals(version2.toString(), "10.08");
      assertEquals(version2.getMajor(), "10");
      assertEquals(version2.getMinor(), "08");
      assertEquals(version2.getBuild(), "");

      Version version3 = Version.fromString("00534");
      assertEquals(version3.toString(), "00534");
      assertEquals(version3.getMajor(), "00534");
      assertEquals(version3.getMinor(), "");
      assertEquals(version3.getBuild(), "");

      Version version4 = Version.fromString("4");
      assertEquals(version4.toString(), "4");
      assertEquals(version4.getMajor(), "4");
      assertEquals(version4.getMinor(), "");
      assertEquals(version4.getBuild(), "");

      Version version5 = Version.fromString("0.0.022");
      assertEquals(version5.toString(), "0.0.022");
      assertEquals(version5.getMajor(), "0");
      assertEquals(version5.getMinor(), "0");
      assertEquals(version5.getBuild(), "022");
   }

   @Test
   public void testCompareTo()
   {
      Version version1 = Version.fromString("1.04.3");
      Version version2 = Version.fromString("01.4.003");
      assertTrue(version1.compareTo(version2) == 0);

      Version version3 = Version.fromString("10.043");
      Version version4 = Version.fromString("0010.43");
      assertTrue(version3.compareTo(version4) == 0);

      Version version5 = Version.fromString("1440");
      Version version6 = Version.fromString("0001440");
      assertTrue(version5.compareTo(version6) == 0);

      Version version7 = Version.fromString("10.44.004");
      Version version8 = Version.fromString("10.44.006");
      assertTrue(version7.compareTo(version8) < 0);

      Version version9 = Version.fromString("10.044.999");
      Version version10 = Version.fromString("10.0045.00");
      assertTrue(version9.compareTo(version10) < 0);

      Version version11 = Version.fromString("058.999.999");
      Version version12 = Version.fromString("80");
      assertTrue(version11.compareTo(version12) < 0);

      Version version13 = Version.fromString("78.05.05");
      Version version14 = Version.fromString("059.999.999");
      assertTrue(version13.compareTo(version14) > 0);
   }

   @Test(expected = IllegalArgumentException.class)
   public void testIllegalArgumentException()
   {
      Version.fromString("10.4a");
   }
}
