//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: ivolvovski
//
// Date: Jun 14, 2007
//---------------------

package org.cleversafe.util;

import static org.junit.Assert.assertEquals;

import org.cleversafe.util.TypeUtils;
import org.junit.Test;

// TODO: Describe class or interface
public class TypeUtilsTest
{
   @Test
   public void test1()
   {
      assertEquals(TypeUtils.getNonPrimitiveFor(String.class), String.class);
      assertEquals(TypeUtils.getNonPrimitiveFor(Integer.class), Integer.class);
      assertEquals(TypeUtils.getNonPrimitiveFor(int.class), Integer.class);
      assertEquals(TypeUtils.getNonPrimitiveFor(Boolean.class), Boolean.class);
      assertEquals(TypeUtils.getNonPrimitiveFor(boolean.class), Boolean.class);
      assertEquals(TypeUtils.getNonPrimitiveFor(char.class), Character.class);
      assertEquals(TypeUtils.getNonPrimitiveFor(short.class), Short.class);
      assertEquals(TypeUtils.getNonPrimitiveFor(long.class), Long.class);
      assertEquals(TypeUtils.getNonPrimitiveFor(float.class), Float.class);
      assertEquals(TypeUtils.getNonPrimitiveFor(double.class), Double.class);
     
      assertEquals(TypeUtils.getPrimitiveFor(Integer.class), int.class);
      assertEquals(TypeUtils.getPrimitiveFor(Boolean.class), boolean.class);

      assertEquals(TypeUtils.getByPrimitiveName("int"), TypeUtils.INT);
      assertEquals(TypeUtils.getByPrimitiveName("double"), TypeUtils.DOUBLE);

      assertEquals(TypeUtils.getByPrimitiveClass(int.class), TypeUtils.INT);
      assertEquals(TypeUtils.getByPrimitiveClass(double.class), TypeUtils.DOUBLE);
      
      assertEquals(TypeUtils.getByWrapperClass(Boolean.class), TypeUtils.BOOLEAN);
      assertEquals(TypeUtils.getByWrapperClass(Character.class), TypeUtils.CHAR);

      assertEquals(TypeUtils.isAssignableFrom(int.class, short.class), true);
      assertEquals(TypeUtils.isAssignableFrom(Integer.class, short.class), true);
      assertEquals(TypeUtils.isAssignableFrom(Integer.class, Short.class), true);
      assertEquals(TypeUtils.isAssignableFrom(Integer.class, Byte.class), true);
      assertEquals(TypeUtils.isAssignableFrom(float.class, Byte.class), true);
      
      assertEquals(TypeUtils.isAssignableFrom(int.class, long.class), false);
      assertEquals(TypeUtils.isAssignableFrom(int.class, double.class), false);
      assertEquals(TypeUtils.isAssignableFrom(float.class, double.class), false);
      assertEquals(TypeUtils.isAssignableFrom(Float.class, double.class), false);
      
      assertEquals(TypeUtils.isAssignableFrom(Number.class, Integer.class), true);
      assertEquals(TypeUtils.isAssignableFrom(Integer.class, Number.class), false);

      assertEquals(TypeUtils.isAssignableFrom(Integer.class, String.class), false);
      assertEquals(TypeUtils.isAssignableFrom(Object.class, String.class), true);
      assertEquals(TypeUtils.isAssignableFrom(String.class, Object.class), false);         
   }

}


