//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: ivolvovski
//
// Date: May 25, 2007
//---------------------

package org.cleversafe.util;

import static org.junit.Assert.assertEquals;

import org.cleversafe.util.NamingHelper;
import org.junit.Test;

// TODO: Describe class or interface
public class NamingHelperTest
{
   @Test
   public void testConvertNameIntoJavaSetter()
   {
      assertEquals(NamingHelper.convertNameIntoJavaSetter("xyz"), "setXyz");
      assertEquals(NamingHelper.convertNameIntoJavaSetter("Xyz"), "setXyz");
      assertEquals(NamingHelper.convertNameIntoJavaSetter("block-device"), "setBlockDevice");
      assertEquals(NamingHelper.convertNameIntoJavaSetter("block-device-size"),
            "setBlockDeviceSize");
   }

   @Test
   public void testConvertNameIntoJavaGetter()
   {
      assertEquals(NamingHelper.convertNameIntoJavaGetter("xyz"), "getXyz");
   }

   @Test
   public void testConvertNameIntoJavaMethod()
   {
      assertEquals(NamingHelper.convertNameIntoJavaMethod("xyz", "is", null), "isXyz");
      assertEquals(NamingHelper.convertNameIntoJavaMethod("xyz", "is", "3"), "isXyz3");
      assertEquals(NamingHelper.convertNameIntoJavaMethod("block-device", "is", null),
            "isBlockDevice");
      assertEquals(NamingHelper.convertNameIntoJavaMethod("block-device_under", "is", null),
            "isBlockDevice_under");

   }

}
