//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: Zach
//
// Date: Jun 20, 2007
//---------------------

package org.cleversafe.util;

import static org.junit.Assert.fail;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Random;

import org.apache.log4j.Logger;
import org.cleversafe.test.BaseTest;
import org.cleversafe.util.exceptions.ResolutionException;
import org.junit.BeforeClass;
import org.junit.Test;

/**
 * Test of the FileResolver class.
 * 
 */
public class FileResolverUnitTest
{
   private static Logger _logger = Logger.getLogger(FileResolverUnitTest.class);

   private static final String FILE_RESOURCE = "org.cleversafe.authentication.credentialspath";
   private static final String CONFIG_LOC =
         System.getProperty(BaseTest.TEST_INPUT_PROPERTY, ".") + "/org/cleversafe/util";

   private static final String DEFAULT_NAME = "default.bin";
   private static final String OVERRIDE_NAME = "override.bin";
   private static final String PROPERTY_NAME = "system.bin";

   private static File defaultFile;
   private static File overrideFile;
   private static String propertyPath;

   @BeforeClass
   public static void setUpBeforeClass() throws Exception
   {
      //System.setProperty(FILE_RESOURCE, CONFIG_LOC);
      defaultFile = new File(CONFIG_LOC + File.separator + DEFAULT_NAME);
      overrideFile = new File(CONFIG_LOC + File.separator + OVERRIDE_NAME);
      propertyPath = CONFIG_LOC + File.separator + PROPERTY_NAME;
   }

   private boolean fileWriteRead(Resolver resolver, File path) throws ResolutionException,
         IOException
   {
      if (path.exists())
      {
         fail("output file already exists before unit test run");
      }

      byte[] input = new byte[1024];
      byte[] output = new byte[1024];
      Random rand = new Random();
      rand.nextBytes(output);

      OutputStream out = resolver.getOutputStream();
      out.write(output);
      out.close();

      if (!path.exists())
      {
         fail("resolved did not create the expected output file");
      }

      InputStream in = resolver.getInputStream();
      in.read(input);
      in.close();

      path.delete();

      return Arrays.equals(output, input);
   }

   @Test
   public void testDefaultPath() throws Exception
   {
      _logger.debug("Testing file resolver with valid default path");
      FileResolver resolver = new FileResolver(FILE_RESOURCE, defaultFile, null);

      fileWriteRead(resolver, defaultFile.getAbsoluteFile());
   }

   @Test
   public void testPropertyPath() throws Exception
   {
      _logger.debug("Testing file resolver with valid system property setting");
      System.setProperty(FILE_RESOURCE, propertyPath);
      FileResolver resolver = new FileResolver(FILE_RESOURCE, null, null);

      fileWriteRead(resolver, new File(propertyPath));

      System.clearProperty(FILE_RESOURCE);
   }

   @Test
   public void testOverridePath() throws Exception
   {
      _logger.debug("Testing file resolver with path override value");
      FileResolver resolver = new FileResolver(FILE_RESOURCE, defaultFile, overrideFile);

      fileWriteRead(resolver, overrideFile);
   }

}
