//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: dhendrickson
//
// Date: Oct 30, 2007
//---------------------

package org.cleversafe.test;

import static org.junit.Assert.assertTrue;

import java.io.File;

import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class BaseTestTest extends BaseTest
{
   private String testInputProperty = "";
   private String testOutputProperty = "";
   
   @BeforeClass
   public static void setupBefore() throws Exception
   {
      if(System.getProperty(BaseTest.TEST_INPUT_PROPERTY) == null)
      {
         throw new Exception("Must set property " + BaseTest.TEST_INPUT_PROPERTY);
      }
      
      if(System.getProperty(BaseTest.TEST_OUTPUT_PROPERTY) == null)
      {
         throw new Exception("Must set property " + BaseTest.TEST_OUTPUT_PROPERTY);
      }
   }
   
   @Before
   public void setup() throws Exception
   {
      this.testInputProperty = System.getProperty(BaseTest.TEST_INPUT_PROPERTY);
      this.testOutputProperty = System.getProperty(BaseTest.TEST_OUTPUT_PROPERTY);
            
      System.clearProperty(BaseTest.TEST_INPUT_PROPERTY);
      System.clearProperty(BaseTest.TEST_OUTPUT_PROPERTY);
   }
   
   @After
   public void cleanup()
   {
      System.setProperty(BaseTest.TEST_INPUT_PROPERTY, this.testInputProperty);
      System.setProperty(BaseTest.TEST_OUTPUT_PROPERTY, this.testOutputProperty); 
   }
   
   @Test
   public void testInput()
   {
      boolean isError;
      
      isError = false;      
      try
      {
         super.getInputDirectory();
      }
      catch(TestException ex)
      {
         isError = true;
      }
      assertTrue("Expected error did not occur", isError);
      
      System.setProperty(BaseTest.TEST_INPUT_PROPERTY, this.testInputProperty);
      isError = false;
      try
      {
         super.getInputDirectory();
      }
      catch(TestException ex)
      {
         isError = true;
      }
      assertTrue("Unable to retrieve input directory", !isError);
   }
   
   @Test
   public void testOutput()
   {
      boolean isError;
      
      isError = false;      
      try
      {
         super.getOutputDirectory();
      }
      catch(TestException ex)
      {
         isError = true;
      }
      assertTrue("Expected error did not occur", isError);
      
      System.setProperty(BaseTest.TEST_OUTPUT_PROPERTY, this.testOutputProperty);
      isError = false;
      try
      {
         super.getOutputDirectory();
      }
      catch(TestException ex)
      {
         isError = true;
      }
      assertTrue("Unable to retrieve output directory", !isError);
   }
   
   @Test
   public void testClean() throws Exception
   {
      System.setProperty(BaseTest.TEST_OUTPUT_PROPERTY, this.testOutputProperty);
      
      File dir = super.getOutputDirectory();
      
      assertTrue("Failed to create output directory", dir.exists());
      super.clean();
      assertTrue("Failed to remove output directory", !dir.exists());
   }
}


