package org.cleversafe.server;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

public class ClientSessionTest
{
   @Test
   public void testConstants()
   {
      assertEquals("_application_type", ClientSession.APPLICATION_TYPE);
      assertEquals("_grid_account_uuid", ClientSession.GRID_ACCOUNT_UUID);
      assertEquals("_slice_store", ClientSession.SLICE_STORE);
      assertEquals("_vault_uuid", ClientSession.VAULT_UUID);
      assertEquals("_vault_permission", ClientSession.VAULT_PERMISSION);
      assertEquals("_authenticated", ClientSession.AUTHENTICATED);
      assertEquals("_write_permission", ClientSession.WRITE_PERMISSION);
      assertEquals("_read_permission", ClientSession.READ_PERMISSION);
      assertEquals("_list_permission", ClientSession.LIST_PERMISSION);
   }
   
   @Test
   public void testConstructor()
   {
      ClientSession session = new ClientSession();
      
      assertTrue(!session.containsKey(ClientSession.APPLICATION_TYPE));
      assertTrue(!session.containsKey(ClientSession.GRID_ACCOUNT_UUID));
      assertTrue(!session.containsKey(ClientSession.SLICE_STORE));
      assertTrue(!session.containsKey(ClientSession.VAULT_UUID));
      assertTrue(!session.containsKey(ClientSession.VAULT_PERMISSION));
      assertTrue(!session.containsKey(ClientSession.AUTHENTICATED));
      assertTrue(!session.containsKey(ClientSession.WRITE_PERMISSION));
      assertTrue(!session.containsKey(ClientSession.READ_PERMISSION));
      assertTrue(!session.containsKey(ClientSession.LIST_PERMISSION));
   }
   
   @Test
   public void testPutAndContainsKey()
   {
      ClientSession session = new ClientSession();
      
      assertTrue(!session.containsKey(ClientSession.APPLICATION_TYPE));
      session.put(ClientSession.APPLICATION_TYPE, "test");
      assertTrue(session.containsKey(ClientSession.APPLICATION_TYPE));
   }
   
   @Test
   public void testGet()
   {
      ClientSession session = new ClientSession();
      
      String testValue = "test";
      session.put(ClientSession.APPLICATION_TYPE, testValue);
      String value = (String)session.get(ClientSession.APPLICATION_TYPE);
      
      assertEquals(testValue, value);
   }
   
   @Test
   public void testRemove()
   {
      ClientSession session = new ClientSession();
      
      String testValue = "test";
      session.put(ClientSession.APPLICATION_TYPE, testValue);
      session.remove(ClientSession.APPLICATION_TYPE);
      String value = (String)session.get(ClientSession.APPLICATION_TYPE);
      
      assertEquals(null, value);
   }
   
   @Test
   public void testToString()
   {
      ClientSession session = new ClientSession();
      
      assertEquals("SESSION[VAULT=UNKNOWN ACCOUNT=UNKNOWN]", session.toString());
      
      session.put(ClientSession.VAULT_UUID, "vault_id");
      assertEquals("SESSION[VAULT=vault_id ACCOUNT=UNKNOWN]", session.toString());
      session.remove(ClientSession.VAULT_UUID);
      
      session.put(ClientSession.VAULT_UUID, "vault_id");
      assertEquals("SESSION[VAULT=vault_id ACCOUNT=UNKNOWN]", session.toString());
      session.remove(ClientSession.VAULT_UUID);
      
      session.put(ClientSession.GRID_ACCOUNT_UUID, "account_id");
      assertEquals("SESSION[VAULT=UNKNOWN ACCOUNT=account_id]", session.toString());
      
      session.put(ClientSession.VAULT_UUID, "vault_id");
      assertEquals("SESSION[VAULT=vault_id ACCOUNT=account_id]", session.toString());
   }
}
