//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: mmotwani
//
// Date: Oct 9, 2007
//---------------------

package org.cleversafe.serialization.raw.custom;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.io.IOException;

import org.cleversafe.serialization.GridSerializable;
import org.cleversafe.serialization.exceptions.EncodeDecodeException;

public abstract class CustomRawSerializationTestBase
{
   private static CustomRawSerialization serialization;

   protected CustomRawSerializationTestBase(Class<? extends GridSerializable> cls)
   {
      serialization = CustomRawSerializationRegistrator.getCustomSerialization(cls);
   }

   protected <T extends GridSerializable> void testEncodeDecode(T serializable)
   {
      try
      {
         byte[] bytes = serialization.encode(serializable);
         GridSerializable decoded = serialization.decode(serializable.getClass(), bytes);
         assertEquals(decoded.getClass(), serializable.getClass());
         assertTrue(decoded.equals(serializable));
      }
      catch (IOException e)
      {
         fail(e.getMessage());
      }
      catch (EncodeDecodeException e)
      {
         fail(e.getMessage());
      }
   }
}
