//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: mmotwani
//
// Date: Sep 7, 2007
//---------------------

package org.cleversafe.serialization.asn1.custom;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.util.HashMap;

import org.bouncycastle.asn1.ASN1Object;
import org.cleversafe.layer.grid.SliceName;
import org.cleversafe.layer.grid.SourceName;
import org.cleversafe.serialization.asn1.custom.SliceNameSerialization;
import org.junit.BeforeClass;
import org.junit.Test;

public class SliceNameSerializationTest
{
   private static SliceNameSerialization serialization;

   @BeforeClass
   public static void setUpBeforeClass() throws Exception
   {
      SliceNameSerializationTest.serialization = new SliceNameSerialization();
   }

   @Test
   public void testGetSerializationClass()
   {
      assertEquals(SliceNameSerializationTest.serialization.getSerializableClass(),
            SliceName.class);
   }

   @Test
   public void testGetEncodeMethod() throws NoSuchMethodException
   {
      assertEquals(SliceNameSerializationTest.serialization.getEncodeMethod(),
            SliceNameSerialization.class.getMethod("encodeSliceName", new Class[]{
               SliceName.class
            }));
   }

   @Test
   public void testGetDecodeMethod() throws NoSuchMethodException
   {
      assertEquals(SliceNameSerializationTest.serialization.getDecodeMethod(),
            SliceNameSerialization.class.getMethod("decodeSliceName", new Class[]{
                  SliceName.class, ASN1Object.class
            }));
   }

   @Test
   public void testEncodeDecodeSliceName1()
   {
      SliceName sliceName = new SliceName();
      ASN1Object asnObj = SliceNameSerialization.encodeSliceName(sliceName);

      SliceName returnedSliceName = new SliceName();
      SliceNameSerialization.decodeSliceName(returnedSliceName, asnObj);

      assertTrue(sliceName.equals(returnedSliceName));
   }

   @Test
   public void testEncodeDecodeSliceName2()
   {
      SliceName sliceName = new SliceName("My Slice Name", 5);
      ASN1Object asnObj = SliceNameSerialization.encodeSliceName(sliceName);

      SliceName returnedSliceName = new SliceName();
      SliceNameSerialization.decodeSliceName(returnedSliceName, asnObj);

      assertTrue(sliceName.equals(returnedSliceName));
   }

   @Test
   public void testEncodeDecodeSliceName3()
   {
      SliceName sliceName = new SliceName(new SourceName("My slice name"), 5);
      ASN1Object asnObj = SliceNameSerialization.encodeSliceName(sliceName);

      SliceName returnedSliceName = new SliceName();
      SliceNameSerialization.decodeSliceName(returnedSliceName, asnObj);

      assertTrue(sliceName.equals(returnedSliceName));
   }

   @Test
   public void testEncodeDecodeSliceName4()
   {
      SliceName sliceName =
            new SliceName(new SourceName("My slice name", new HashMap<String, String>()), 5);
      ASN1Object asnObj = SliceNameSerialization.encodeSliceName(sliceName);

      SliceName returnedSliceName = new SliceName();
      SliceNameSerialization.decodeSliceName(returnedSliceName, asnObj);

      assertTrue(sliceName.equals(returnedSliceName));
   }

   @Test
   public void testEncodeDecodeSliceName5()
   {
      HashMap<String, String> namedExtensions = new HashMap<String, String>();
      namedExtensions.put("abc", "abcdef");
      namedExtensions.put("what", "hello there");
      namedExtensions.put("this", "is a test");

      SliceName sliceName = new SliceName(new SourceName("My slice name", namedExtensions), 5);
      ASN1Object asnObj = SliceNameSerialization.encodeSliceName(sliceName);

      SliceName returnedSliceName = new SliceName();
      SliceNameSerialization.decodeSliceName(returnedSliceName, asnObj);

      assertTrue(sliceName.equals(returnedSliceName));
   }
}
