//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: mmotwani
//
// Date: Sep 7, 2007
//---------------------

package org.cleversafe.serialization.asn1.custom;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import org.bouncycastle.asn1.ASN1Object;
import org.cleversafe.layer.grid.SourceName;
import org.cleversafe.layer.slicestore.SliceInfo;
import org.cleversafe.serialization.asn1.custom.SliceInfoSerialization;
import org.junit.BeforeClass;
import org.junit.Test;

public class SliceInfoSerializationTest
{
   private static SliceInfoSerialization serialization;

   @BeforeClass
   public static void setUpBeforeClass() throws Exception
   {
      SliceInfoSerializationTest.serialization = new SliceInfoSerialization();
   }

   @Test
   public void testGetSerializationClass()
   {
      assertEquals(SliceInfoSerializationTest.serialization.getSerializableClass(),
            SliceInfo.class);
   }

   @Test
   public void testGetEncodeMethod() throws NoSuchMethodException
   {
      assertEquals(SliceInfoSerializationTest.serialization.getEncodeMethod(),
            SliceInfoSerialization.class.getMethod("encodeSliceInfo", new Class[]{
               SliceInfo.class
            }));
   }

   @Test
   public void testGetDecodeMethod() throws NoSuchMethodException
   {
      assertEquals(SliceInfoSerializationTest.serialization.getDecodeMethod(),
            SliceInfoSerialization.class.getMethod("decodeSliceInfo", new Class[]{
                  SliceInfo.class, ASN1Object.class
            }));
   }

   @Test
   public void testEncodeDecodeSliceInfo1()
   {
      SliceInfo sliceInfo = new SliceInfo();
      ASN1Object asnObj = SliceInfoSerialization.encodeSliceInfo(sliceInfo);

      SliceInfo returnedSliceInfo = new SliceInfo();
      SliceInfoSerialization.decodeSliceInfo(returnedSliceInfo, asnObj);

      assertTrue(sliceInfo.equals(returnedSliceInfo));
   }

   @Test
   public void testEncodeDecodeSliceInfo2()
   {
      SliceInfo sliceInfo = new SliceInfo(new SourceName("My source name"), 42341);
      ASN1Object asnObj = SliceInfoSerialization.encodeSliceInfo(sliceInfo);

      SliceInfo returnedSliceInfo = new SliceInfo();
      SliceInfoSerialization.decodeSliceInfo(returnedSliceInfo, asnObj);

      assertTrue(sliceInfo.equals(returnedSliceInfo));
   }
}
