//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: ivolvovski
//
// Date: May 2, 2007
//---------------------

package org.cleversafe.serialization.asn1;

import static org.junit.Assert.assertEquals;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.cleversafe.serialization.GridSerializable;
import org.cleversafe.test.BaseTest;
import org.junit.Test;

// TODO: Describe class or interface
public class ASN1TestList
{
   static public class OtherClass implements GridSerializable
   {
      private int intN = 0;
      private boolean boolN = false;

      public OtherClass()
      {
      }

      public OtherClass(int intN, boolean boolN)
      {
         this.intN = intN;
         this.boolN = boolN;
      }

      public boolean equals(OtherClass o)
      {
         return this.intN == o.intN && this.boolN == o.boolN;
      }

   }
   public static class TestClass implements GridSerializable
   {
      private final byte byteP;
      private final List<Integer> list;
      private final int intP;

      public TestClass(byte byteP, int intP, List<Integer> list)
      {
         this.byteP = byteP;
         this.intP = intP;
         this.list = new ArrayList<Integer>(list);
      }

      @Override
      public boolean equals(Object other)
      {
         TestClass testClass = (TestClass) other;
         if (this.byteP == testClass.byteP && this.intP == testClass.intP
               && this.list.equals(testClass.list))
            return true;
         else
            return false;
      }

      @Override
      public String toString()
      {
         return this.byteP + "," + this.intP + "," + this.list;
      }
   }

   @Test
   public void testEncodeDecode()
   {
      try
      {
         // Instantiate the first test class
         TestClass testClass1 = new TestClass((byte) 1, 25, Arrays.asList(new Integer[]{
               9, 99, 999
         }));
         System.out.println(testClass1);
         // Produce ASN.1 encoded byte stream
         byte[] encodedBytes = ASN1.DERConverter.encode(testClass1);

         File f =
               new File(System.getProperty(BaseTest.TEST_OUTPUT_PROPERTY, ".")
                     + "/ASN1TestList.der");
         f.getParentFile().mkdirs();
         f.createNewFile();
         FileOutputStream fo = new FileOutputStream(f);
         fo.write(encodedBytes);
         fo.close();

         TestClass testClass2 = new TestClass((byte) 0, 0, Arrays.asList(new Integer[]{}));
         System.out.println(testClass2);
         ASN1.DERConverter.decode(testClass2, encodedBytes);

         // Check if the first class is equal to the second class
         System.out.println(testClass2);
         assertEquals(testClass1, testClass2);
      }
      catch (Exception ex)
      {
         ex.printStackTrace();
      }
   }
}
