//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: ivolvovski
//
// Date: May 3, 2007
//---------------------

package org.cleversafe.serialization.asn1;

import static org.junit.Assert.assertEquals;

import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.DERGeneralString;
import org.bouncycastle.asn1.DERSequence;
import org.cleversafe.serialization.GridSerializable;
import org.cleversafe.test.BaseTest;
import org.junit.Test;

// TODO: Describe class or interface
public class ASN1ExternalSerializationTest
{

   public static class AnotherClass implements GridSerializable
   {
      private final Map<String, String> m = new HashMap<String, String>();

      public AnotherClass(Map<String, String> m)
      {
         this.m.putAll(m);
      }

      /*
       * (non-Javadoc)
       * 
       * @see java.lang.Object#equals(java.lang.Object)
       */
      @Override
      public boolean equals(Object other)
      {
         if (!(other instanceof AnotherClass))
            return false;
         return this.m.equals(((AnotherClass) other).m);
      }

      /*
       * (non-Javadoc)
       * 
       * @see java.lang.Object#toString()
       */
      @Override
      public String toString()
      {
         return this.m.toString();
      }

   }
   public static class OtherClass implements GridSerializable
   {
      private String s1;
      private String s2;
      private String s3;

      /**
       * @param s1
       * @param s2
       * @param s3
       */
      public OtherClass(String s1, String s2, String s3)
      {
         super();
         this.s1 = s1;
         this.s2 = s2;
         this.s3 = s3;
      }

      /*
       * (non-Javadoc)
       * 
       * @see java.lang.Object#hashCode()
       */
      /*
       * (non-Javadoc)
       * 
       * @see java.lang.Object#equals(java.lang.Object)
       */
      @Override
      public boolean equals(Object obj)
      {
         if (this == obj)
            return true;
         if (obj == null)
            return false;
         if (getClass() != obj.getClass())
            return false;
         final OtherClass other = (OtherClass) obj;
         if (this.s1 == null)
         {
            if (other.s1 != null)
               return false;
         }
         else if (!this.s1.equals(other.s1))
            return false;
         if (this.s2 == null)
         {
            if (other.s2 != null)
               return false;
         }
         else if (!this.s2.equals(other.s2))
            return false;
         if (this.s3 == null)
         {
            if (other.s3 != null)
               return false;
         }
         else if (!this.s3.equals(other.s3))
            return false;

         return true;
      }

      /*
       * (non-Javadoc)
       * 
       * @see java.lang.Object#toString()
       */
      @Override
      public String toString()
      {
         return "[" + this.s1 + ":" + this.s2 + ":" + this.s3 + "]";
      }
   }
   public static class TestClass implements GridSerializable
   {
      static boolean init = ExternalSerializer.initExternal();

      static public class ExternalSerializer
      {
         static boolean initExternal()
         {
            try
            {
               ASN1.DERConverter.registerDefaultEncodeDecode(OtherClass.class,
                     ExternalSerializer.class.getMethod("myEncode", OtherClass.class),
                     ExternalSerializer.class.getMethod("myDecode", OtherClass.class,
                           ASN1Object.class));
               ASN1.DERConverter.registerDefaultEncodeDecode(Map.class,
                     ExternalSerializer.class.getMethod("encodeMap", Map.class),
                     ExternalSerializer.class.getMethod("decodeList", Map.class, ASN1Object.class));
               ASN1.DERConverter.registerClassEncodeDecode(Map.class, TestClass.class,
                     ExternalSerializer.class.getMethod("encodeMapSpecial", Map.class),
                     ExternalSerializer.class.getMethod("decodeMapSpecial", Map.class,
                           ASN1Object.class));
            }
            catch (SecurityException e)
            {
               // TODO Auto-generated catch block
               e.printStackTrace();
            }
            catch (NoSuchMethodException e)
            {
               // TODO Auto-generated catch block
               e.printStackTrace();
            }
            return true;
         }

         public static DERSequence encodeMap(Map<String, String> map)
         {
            if (map == null)
            {
               return new DERSequence();
            }
            DERSequence[] seq = new DERSequence[map.size()];
            Set<String> keys = map.keySet();
            int i = 0;
            for (String key : keys)
            {

               seq[i++] = new DERSequence(new DERGeneralString[]{
                     new DERGeneralString(key), new DERGeneralString(map.get(key))
               });
            }
            return new DERSequence(seq);
         }

         public static void decodeList(Map<String, String> map, ASN1Object asnObj)
         {
            DERSequence seq = (DERSequence) asnObj;
            if (map != null)
            {
               map.clear();
            }
            else
            {
               map = new HashMap<String, String>();
            }
            for (int i = 0; i < seq.size(); i++)
            {
               DERSequence pair = (DERSequence) seq.getObjectAt(i);
               String key = ((DERGeneralString) pair.getObjectAt(0)).getString();
               String value = ((DERGeneralString) pair.getObjectAt(1)).getString();
               map.put(key, value);
            }
         }

         public static DERSequence encodeMapSpecial(Map<String, String> map)
         {
            if (map == null)
            {
               return new DERSequence();
            }
            StringBuffer keyStr = new StringBuffer();
            StringBuffer valueStr = new StringBuffer();

            Set<String> keys = map.keySet();
            for (String key : keys)
            {
               keyStr.append(key).append('/');
               valueStr.append(map.get(key)).append('#');
            }
            return new DERSequence(new DERGeneralString[]{
                  new DERGeneralString(keyStr.toString()),
                  new DERGeneralString(valueStr.toString())
            });
         }

         public static void decodeMapSpecial(Map<String, String> map, ASN1Object asnObj)
         {
            if (map != null)
            {
               map.clear();
            }
            else
            {
               map = new HashMap<String, String>();
            }
            DERSequence pair = (DERSequence) asnObj;
            String keyStr = ((DERGeneralString) pair.getObjectAt(0)).getString();
            String valueStr = ((DERGeneralString) pair.getObjectAt(1)).getString();

            String[] keys = keyStr.split("/");
            String[] values = valueStr.split("#");
            for (int i = 0; i < values.length; i++)
            {
               map.put(keys[i], values[i]);
            }
         }

         public static DERGeneralString myEncode(OtherClass o)
         {
            return new DERGeneralString(o.s1 + ":" + o.s2 + ":" + o.s3);
         }

         public static void myDecode(OtherClass o, ASN1Object asnObj)
         {
            DERGeneralString derStr = (DERGeneralString) asnObj;
            String[] array = derStr.getString().split(":");
            o.s1 = array.length > 0 ? array[0] : null;
            o.s2 = array.length > 1 ? array[1] : null;
            o.s3 = array.length > 2 ? array[2] : null;
         }
      }
      private final int intP;
      private final OtherClass custom;
      private final Map<String, String> map;
      private final String s;
      private final AnotherClass a;

      /**
       * @param intP
       * @param custom
       * @param s
       */
      public TestClass(int intP, OtherClass custom, AnotherClass a, String s, String[] array)
      {
         super();
         this.intP = intP;
         this.custom = custom;
         this.s = s;

         this.map = new HashMap<String, String>();
         for (int i = 0; i < array.length; i += 2)
         {
            this.map.put(array[i], array[i + 1]);
         }

         this.a = a;
      }

      /*
       * (non-Javadoc)
       * 
       * @see java.lang.Object#equals(java.lang.Object)
       */
      @Override
      public boolean equals(Object obj)
      {
         if (obj == null || !(obj instanceof TestClass))
         {
            return false;
         }
         TestClass other = (TestClass) obj;
         return this.intP == other.intP && this.custom.equals(other.custom)
               && this.s.equals(other.s) && this.map.equals(other.map) && this.a.equals(other.a);
      }

      /*
       * (non-Javadoc)
       * 
       * @see java.lang.Object#toString()
       */
      @Override
      public String toString()
      {
         return "{" + this.intP + "," + this.custom + "," + this.map + "," + this.s + "," + this.a
               + "}";
      }
   }

   @Test
   public void testEncodeDecode()
   {
      try
      {
         Map<String, String> m1 = new HashMap<String, String>();
         m1.put("play", "tennis");
         m1.put("enjoy", "life");
         // Instantiate the first test class
         TestClass testClass1 =
               new TestClass(99, new OtherClass("a", "b", "c"), new AnotherClass(m1), "str1",
                     new String[]{
                           "0", "9", "special", "serizlization"
                     });
         Map<String, String> m2 = new HashMap<String, String>();
         TestClass testClass2 =
               new TestClass(88, new OtherClass("X", "Y", "Z"), new AnotherClass(m2), "ABC",
                     new String[]{});

         System.out.println(testClass1);
         System.out.println(testClass2);
         // Produce ASN.1encoded byte stream
         byte[] encodedBytes = ASN1.DERConverter.encode(testClass1);

         File f =
               new File(System.getProperty(BaseTest.TEST_OUTPUT_PROPERTY, ".")
                     + "/ASN1ExternalSerializer.der");
         f.getParentFile().mkdirs();
         f.createNewFile();
         FileOutputStream fo = new FileOutputStream(f);
         fo.write(encodedBytes);
         fo.close();

         ASN1.DERConverter.decode(testClass2, encodedBytes);
         System.out.println(testClass2);
         assertEquals(testClass1, testClass2);

      }
      catch (Exception ex)
      {
         ex.printStackTrace();
      }
   }
}
