//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: ivolvovski
//
// Date: May 10, 2007
//---------------------

package org.cleversafe.serialization.asn1;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.io.File;
import java.io.FileOutputStream;

import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.DERInteger;
import org.cleversafe.exceptions.BaseException;
import org.cleversafe.server.exceptions.IllegalSessionStateException;
import org.cleversafe.test.BaseTest;
import org.junit.BeforeClass;
import org.junit.Test;

// TODO: Describe class or interface
public class ASN1ExceptionWrapperTest
{
   public static class MyException extends BaseException
   {
      /**
       * 
       */
      private static final long serialVersionUID = 985111075255294928L;
      private int index;

      public MyException()
      {
         this(0);
      }

      public MyException(int index)
      {
         super();
         this.index = index;
      }

      public MyException(int index, Throwable arg0)
      {
         super(arg0);
         this.index = index;
      }

      public int getIndex()
      {
         return this.index;
      }

      public void setIndex(int index)
      {
         this.index = index;
      }

      @Override
      public String getMessage()
      {

         return "Index=" + this.index + " " + super.getMessage();
      }
   }

   @BeforeClass
   public static void oneTimeSetUp() throws Exception
   {
      System.clearProperty(ExceptionRegistrator.ERROR_DEFINITION_PROPERTY);
      ASN1ExceptionWrapper.clearRegistry();
      ExceptionRegistrator.loadAndRegister();
      ASN1ExceptionWrapper.registerException("MyException", MyException.class);

      ASN1.DERConverter.registerDefaultEncodeDecode(ASN1ExceptionWrapperTest.MyException.class,
            ASN1ExceptionWrapperTest.class.getMethod("encodeMyException", MyException.class),
            ASN1ExceptionWrapperTest.class.getMethod("decodeMyException", MyException.class,
                  ASN1Object.class));

   }

   public static DERInteger encodeMyException(MyException e)
   {
      return new DERInteger(e.getIndex());
   }

   public static void decodeMyException(MyException e, ASN1Object asn1obj)
   {
      e.setIndex(((DERInteger) asn1obj).getValue().intValue());
   }

   @Test
   public void testException1() throws Exception
   {
      ASN1ExceptionWrapper exception =
            new ASN1ExceptionWrapper(new IllegalSessionStateException("blah-blah"));
      System.out.println("Original: " + exception.getOriginalException());

      byte[] encodedBytes = ASN1.DERConverter.encode(exception);

      File f =
            new File(System.getProperty(BaseTest.TEST_OUTPUT_PROPERTY, ".")
                  + "/ExceptionSerialization.der");
      f.getParentFile().mkdirs();
      f.createNewFile();
      FileOutputStream fo = new FileOutputStream(f);
      fo.write(encodedBytes);
      fo.close();

      ASN1ExceptionWrapper restoredExcept = new ASN1ExceptionWrapper();
      ASN1.DERConverter.decode(restoredExcept, encodedBytes);

      System.out.println("Restored: " + restoredExcept.getOriginalException());

      assertEquals(restoredExcept.getOriginalException().getClass(),
            IllegalSessionStateException.class);
   }

   @Test
   public void testException2() throws Exception
   {
      ASN1ExceptionWrapper exception =
            new ASN1ExceptionWrapper(new MyException(99, new Exception("Fun", new Exception(
                  "More fun"))));
      System.out.println("Original: " + exception.getOriginalException());

      byte[] encodedBytes = ASN1.DERConverter.encode(exception);
      File f =
            new File(System.getProperty(BaseTest.TEST_OUTPUT_PROPERTY, ".")
                  + "/ExceptionSerialization3.der");
      f.getParentFile().mkdirs();
      f.createNewFile();
      FileOutputStream fo = new FileOutputStream(f);
      fo.write(encodedBytes);
      fo.close();

      ASN1ExceptionWrapper restoredExcept = new ASN1ExceptionWrapper();
      ASN1.DERConverter.decode(restoredExcept, encodedBytes);

      System.out.println("Restored: " + restoredExcept.getOriginalException());

      // BaseException is not registed will not be restored
      assertTrue(exception.getOriginalException().getClass().equals(
            restoredExcept.getOriginalException().getClass()));
      int ind1 = ((MyException) exception.getOriginalException()).getIndex();
      int ind2 = ((MyException) restoredExcept.getOriginalException()).getIndex();
      assertEquals(ind1, ind2);

   }
}
