//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: mmotwani
//
// Date: Jan 29, 2008
//---------------------

package org.cleversafe.layer.slicestore.memory;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

import org.cleversafe.layer.slicestore.SliceStore;
import org.cleversafe.layer.slicestore.SliceStoreTestBase;
import org.cleversafe.layer.slicestore.exceptions.IllegalSourceNameException;
import org.cleversafe.layer.slicestore.exceptions.SliceStoreExistsException;
import org.cleversafe.layer.slicestore.exceptions.SliceStoreIOException;
import org.cleversafe.layer.slicestore.exceptions.SliceStoreNotFoundException;
import org.cleversafe.layer.slicestore.exceptions.SliceStoreQuotaException;
import org.cleversafe.layer.slicestore.exceptions.SliceStoreTransactionException;
import org.cleversafe.test.TestException;
import org.cleversafe.vault.exceptions.VaultDescriptorException;
import org.cleversafe.vault.exceptions.VaultIOException;
import org.cleversafe.vault.exceptions.VaultSecurityException;

// TODO: Describe class or interface
public class MemorySliceStoreTest extends SliceStoreTestBase
{
   @Override
   protected void createStore() throws SliceStoreExistsException, SliceStoreIOException
   {
      // Load vault descriptor
      byte[] descriptorBytes = null;

      try
      {
         File vaultDescriptorFile =
               new File(getInputDirectory() + File.separator + "vault-descriptor.xml");
         InputStream in = new FileInputStream(vaultDescriptorFile);
         descriptorBytes = new byte[(int) vaultDescriptorFile.length()];
         in.read(descriptorBytes);
         in.close();
      }
      catch (TestException ex)
      {
      }
      catch (IOException ex)
      {
      }

      this.sliceStore.createStore("memory", 1024 * 1024, 1024 * 1024 * 100, this.vaultACL,
            descriptorBytes);
   }

   @Override
   public SliceStore getSliceStore() throws SliceStoreIOException
   {
      return new MemorySliceStore();
   }

   /**
    * Override some tests that do not currently apply to this store
    */

   @Override
   public void testGetVaultDescriptor() throws SliceStoreIOException, VaultIOException,
         VaultSecurityException, VaultDescriptorException, SliceStoreNotFoundException
   {
      // Ignore this test
   }

   @Override
   public void testIntegrityVerification() throws VaultDescriptorException, SliceStoreIOException,
         IllegalSourceNameException, VaultIOException, VaultSecurityException,
         SliceStoreNotFoundException, SliceStoreTransactionException, SliceStoreQuotaException
   {
      // Ignore this test   
   }

   @Override
   public void testListing() throws SliceStoreTransactionException, SliceStoreIOException,
         SliceStoreNotFoundException, IllegalSourceNameException, SliceStoreQuotaException
   {
      // Ignore this test
   }
}
