//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: Jason
//
// Date: Jul 19, 2007
//---------------------

package org.cleversafe.layer.slicestore;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.util.HashMap;
import java.util.Map;

import org.cleversafe.layer.grid.SourceName;
import org.junit.Before;
import org.junit.Test;


// Tests the SourceName class
public class SourceNameTest
{
   private static final String NAME = "Test Name";
   private static final String NEW_NAME = "New Name";
   private Map<String, String> extensions;
   private Map<String, String> newExtensions;
   
   @Before
   public void setUp()
   {
      extensions = new HashMap<String, String>();
      extensions.put("cherry", "red");
      extensions.put("lime", "green");
      extensions.put("blue berry", "blue");
      
      newExtensions = new HashMap<String, String>();
      newExtensions.put("1", "one");
      newExtensions.put("2", "two");
      newExtensions.put("3", "three");
   }
   
   @Test
   public void testGetNameSimpleConstructor()
   {
      SourceName sourceName = new SourceName(NAME);
      assertEquals(NAME, sourceName.getName());
   }
   
   @Test public void testFullConstructor()
   {
      SourceName sourceName = new SourceName(NAME, extensions);
      
      assertEquals(NAME, sourceName.getName());
      assertTrue(extensions.equals(sourceName.getNamedExtensions()));
   }
   
   @Test
   public void testSetName()
   {
      SourceName sourceName = new SourceName(NAME, extensions);
      
      sourceName.setName(NEW_NAME);
      assertEquals(NEW_NAME, sourceName.getName());
   }
   
   @Test public void testSetExtensions()
   {
      SourceName sourceName = new SourceName(NAME, extensions);
      
      sourceName.setNamedExtensions(newExtensions);
      
      assertTrue(newExtensions.equals(sourceName.getNamedExtensions()));
   }
   
}


