//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: ivolvovski
//
// Date: Jan 26, 2008
//---------------------

package org.cleversafe.layer.slicestore;
import static org.junit.Assert.*;

import java.util.Arrays;
import java.util.Collections;

import org.junit.Before;
import org.junit.Test;

public class GenericRepairAdviceTest
{
   private GenericRepairAdvice advice;
   
   @Before
   public void setup()
   {
      this.advice = new GenericRepairAdvice();
   }
   
   @Test
   public void testGenericRepairAdvice()
   {
      
      assertTrue(this.advice.getCondition() == RepairAdvice.StoreCondition.GOOD);
      assertEquals(Collections.EMPTY_LIST,this.advice.getAdvices());
      assertEquals(false, advice.getMissingDescriptorDefinition());
   }

   @Test
   public void testSetGetCondition()
   {
      assertTrue(this.advice.getCondition() == RepairAdvice.StoreCondition.GOOD);
      this.advice.setCondition(RepairAdvice.StoreCondition.PARTIAL_REPAIR);
      assertTrue(this.advice.getCondition() == RepairAdvice.StoreCondition.PARTIAL_REPAIR);
      this.advice.setCondition(RepairAdvice.StoreCondition.FULL_REPAIR);     
      assertTrue(this.advice.getCondition() == RepairAdvice.StoreCondition.FULL_REPAIR);
      this.advice.setCondition(RepairAdvice.StoreCondition.CORRUPT);     
      assertTrue(this.advice.getCondition() == RepairAdvice.StoreCondition.CORRUPT);
   }
   @Test
   public void testSetProbableCondition()
   {
      assertTrue(this.advice.getCondition() == RepairAdvice.StoreCondition.GOOD);
      this.advice.setCondition(RepairAdvice.StoreCondition.PARTIAL_REPAIR);
      assertTrue(this.advice.getCondition() == RepairAdvice.StoreCondition.PARTIAL_REPAIR);
      this.advice.setCondition(RepairAdvice.StoreCondition.GOOD);
      assertTrue(this.advice.getCondition() == RepairAdvice.StoreCondition.GOOD);
      this.advice.setCondition(RepairAdvice.StoreCondition.PARTIAL_REPAIR);
      assertTrue(this.advice.getCondition() == RepairAdvice.StoreCondition.PARTIAL_REPAIR);
      this.advice.setProbableCondition(RepairAdvice.StoreCondition.GOOD);
      assertTrue(this.advice.getCondition() == RepairAdvice.StoreCondition.PARTIAL_REPAIR);
      this.advice.setProbableCondition(RepairAdvice.StoreCondition.FULL_REPAIR);
      assertTrue(this.advice.getCondition() == RepairAdvice.StoreCondition.FULL_REPAIR);
      this.advice.setProbableCondition(RepairAdvice.StoreCondition.GOOD);
      assertTrue(this.advice.getCondition() == RepairAdvice.StoreCondition.FULL_REPAIR);
      this.advice.setProbableCondition(RepairAdvice.StoreCondition.CORRUPT);
      assertTrue(this.advice.getCondition() == RepairAdvice.StoreCondition.CORRUPT);
      this.advice.setProbableCondition(RepairAdvice.StoreCondition.GOOD);
      assertTrue(this.advice.getCondition() == RepairAdvice.StoreCondition.CORRUPT);
      this.advice.setCondition(RepairAdvice.StoreCondition.GOOD);
      assertTrue(this.advice.getCondition() == RepairAdvice.StoreCondition.GOOD);      }


   @Test
   public void testGetAdvices()
   {
      assertEquals(Collections.EMPTY_LIST,this.advice.getAdvices());
      this.advice.addAdvice("First advice");
      assertEquals(1,this.advice.getAdvices().size());
      assertEquals("First advice", this.advice.getAdvices().get(0));
      try {
         this.advice.getAdvices().get(1);
         fail("Should be out of bounds");
      }
      catch(RuntimeException e)
      {
         assertTrue(true);
      }
      this.advice.addAdvice("Second advice");
      assertEquals(2,this.advice.getAdvices().size());
      assertEquals("First advice", this.advice.getAdvices().get(0));
      assertEquals("Second advice", this.advice.getAdvices().get(1));
   }


   @Test
   public void testAddAdvices()
   {
      this.advice.addAdvices(Arrays.asList(new String[]{"First advice", "Second advice"})); 
      assertEquals(2,this.advice.getAdvices().size());
      assertEquals("First advice", this.advice.getAdvices().get(0));
      assertEquals("Second advice", this.advice.getAdvices().get(1));
   }


   @Test
   public void testClearMissingDescriptorDefinition()
   {
      assertEquals(false, advice.getMissingDescriptorDefinition());
      advice.setMissingDescriptorDefinition();
      assertEquals(true, advice.getMissingDescriptorDefinition());
      advice.clearMissingDescriptorDefinition();
      assertEquals(false, advice.getMissingDescriptorDefinition());
   }
}


