//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: abaptist
//
// Date: Sep 27, 2007
//---------------------

package org.cleversafe.layer.communication.network.policy;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

import org.cleversafe.layer.communication.policy.TimeQueue;
import org.cleversafe.layer.communication.policy.TimeQueueEvent;
import org.junit.Before;
import org.junit.Test;

public class TestTimeQueue
{
   private AtomicInteger eventFiredCount;

   @Before
   public void setUp()
   {
      eventFiredCount = new AtomicInteger();
   }

   @Test
   public void testTimeQueueAddOne() throws InterruptedException
   {
      TimeQueue tq = new TimeQueue(100, "Test Time Queue");
      Thread.yield();
      tq.touch(new TestTimeQueueEventSetEventFired());
      assertEquals(0, eventFiredCount.get());
      Thread.sleep(150);
      assertEquals(1, eventFiredCount.get());
   }

   // similar to the last test, but it will put the
   @Test
   public void testTimeQueueAddOne2() throws InterruptedException
   {
      TimeQueue tq = new TimeQueue(100, "Test Time Queue");
      tq.touch(new TestTimeQueueEventSetEventFired());
      assertEquals(0, eventFiredCount.get());
      Thread.sleep(200);
      assertEquals(1, eventFiredCount.get());
   }

   // similar to the last test, but it will put the
   @Test
   public void testTimeQueueAddThree() throws InterruptedException
   {
      TimeQueue tq = new TimeQueue(50, "Test Time Queue");
      Thread.yield();
      tq.touch(new TestTimeQueueEventSetEventFired());
      tq.touch(new TestTimeQueueEventSetEventFired());
      tq.touch(new TestTimeQueueEventSetEventFired());
      assertEquals(0, eventFiredCount.get());
      Thread.sleep(100);
      assertEquals(3, eventFiredCount.get());
   }

   // similar to the last test, but it will put the
   @Test
   public void testTimeQueueAddThreeWithDelays() throws InterruptedException
   {
      TimeQueue tq = new TimeQueue(100, "Test Time Queue");
      Thread.yield();
      tq.touch(new TestTimeQueueEventSetEventFired());
      Thread.sleep(20);
      tq.touch(new TestTimeQueueEventSetEventFired());
      Thread.sleep(20);
      tq.touch(new TestTimeQueueEventSetEventFired());
      assertEquals(0, eventFiredCount.get());
      Thread.sleep(200);
      assertEquals(3, eventFiredCount.get());
   }

   // similar to the last test, but it will put the
   @Test
   public void testTimeQueueAddHundred() throws InterruptedException
   {
      TimeQueue tq = new TimeQueue(50, "Test Time Queue");
      Thread.yield();
      for (int i = 0; i < 100; i++)
      {
         tq.touch(new TestTimeQueueEventSetEventFired());
         Thread.sleep(20);
      }
      assertTrue(eventFiredCount.get() < 100);
      Thread.sleep(200);
      assertEquals(100, eventFiredCount.get());
   }

   @Test
   public void testLotsChanges() throws InterruptedException
   {
      TimeQueue tq = new TimeQueue(50, "Test Time Queue");

      for (int i = 0; i < 100; i++)
      {
         for (int j = 0; j < 100; j++)
            tq.touch(new TestTimeQueueEventSetEventFired());
         Thread.sleep(20);
      }

      assertTrue(eventFiredCount.get() > 0);
      assertTrue(eventFiredCount.get() < 10000);
      Thread.sleep(200);
      assertEquals(10000, eventFiredCount.get());

   }

   @Test
   public void testRetouchElements() throws InterruptedException
   {
      List<TestTimeQueueEventSetEventFired> list = new ArrayList<TestTimeQueueEventSetEventFired>();
      for (int i = 0; i < 100; i++)
      {
         list.add(new TestTimeQueueEventSetEventFired());
      }

      TimeQueue tq = new TimeQueue(100, "Test Time Queue");

      // touch every element, make sure that they don't get collected
      for (int i = 0; i < 100; i++)
      {
         for (int j = 0; j < 100; j++)
            tq.touch(list.get(j));
         Thread.sleep(20);
      }
      assertEquals(0, eventFiredCount.get());
      Thread.sleep(200);
      assertEquals(100, eventFiredCount.get());

   }

   final class TestTimeQueueEventSetEventFired implements TimeQueueEvent
   {
      public void event()
      {
         eventFiredCount.incrementAndGet();
      }
   }

}
