//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: wleggette
//
// Date: Jan 10, 2008
//---------------------

package org.cleversafe.jmx;
import static org.junit.Assert.*;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Arrays;

import javax.management.JMException;

import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class JMXServiceTest
{
   private static Logger _logger = Logger.getLogger(JMXServiceTest.class);

   private static final String ADDRESS1 = "127.0.0.1";
   private static final String ADDRESS2 = "localhost";
   
   private static final int PORT1 = 12345;
   private static final int PORT2 = 23456;
   private static final int PORT3 = 34567;
   private static final int PORT4 = 45678;
   private static final int PORT5 = 13456;
   private static final int PORT6 = 14567;
   private static final int PORT7 = 22354;
   private static final int PORT8 = 43453;
   
   @BeforeClass
   public static void setupBeforeClass() throws IOException
   {
      JMXService.reset();
   }
   
   @After
   public void afterTest() throws IOException
   {
      JMXService.reset();
   }

   @Test
   public void testGetSingleService() throws InterruptedException
   {
      try
      {
         JMXService service = JMXService.getInstance(ADDRESS1, PORT1);
         assertTrue("MBeanServer should not be the platform server", 
               service.getJMXConnectorServer().getMBeanServer() != 
                  ManagementFactory.getPlatformMBeanServer());
         service.stop();
      }
      catch (JMException e)
      {
         fail("creation of single service failed");
      }
      catch (IOException e)
      {
         fail("creation of single service failed");
      }
   }
   
   @Test
   public void testGetSingleServiceTwoInstancesSameAddress() throws InterruptedException
   {
      try
      {
         JMXService service1 = JMXService.getInstance(ADDRESS1, PORT2);
         JMXService service2 = JMXService.getInstance(ADDRESS1, PORT2);
         assertTrue("Expected service instances to be equal", service1 == service2);
         assertTrue("MBeanServer should not be the platform server", 
               service1.getJMXConnectorServer().getMBeanServer() != 
                  ManagementFactory.getPlatformMBeanServer());
         service1.stop();
         service2.stop();
      }
      catch (JMException e)
      {
         e.printStackTrace();
         fail("creation of single instance failed");
      }
      catch (IOException e)
      {
         e.printStackTrace();
         fail("creation of single instance failed");
      }
   }
   
   @Test
   public void testGetSingleServiceTwoInstancesDifferentAddress() throws InterruptedException
   {
      try
      {
         JMXService service1 = JMXService.getInstance(ADDRESS1, PORT3);
         JMXService service2 = JMXService.getInstance(ADDRESS2, PORT3);
         assertTrue("Expected service instances to be equal", service1 == service2);
         assertTrue("MBeanServer should not be the platform server", 
               service1.getJMXConnectorServer().getMBeanServer() != 
                  ManagementFactory.getPlatformMBeanServer());
         service1.stop();
         service2.stop();
      }
      catch (JMException e)
      {
         fail("creation of single instance failed");
      }
      catch (IOException e)
      {
         fail("creation of single instance failed");
      }
   }
   
   @Test
   public void testGetDoubleServiceTwoInstances() throws InterruptedException
   {
      try
      {
         JMXService service1 = JMXService.getInstance(ADDRESS1, PORT4);
         JMXService service2 = JMXService.getInstance(ADDRESS1, PORT5);
         assertTrue("Expected service instances to not be equal", service1 != service2);
         assertTrue("MBeanServer should not be the platform server", 
               service1.getJMXConnectorServer().getMBeanServer() != 
                  ManagementFactory.getPlatformMBeanServer());
         assertTrue("MBeanServer should not be the platform server", 
               service2.getJMXConnectorServer().getMBeanServer() != 
                  ManagementFactory.getPlatformMBeanServer());
         service1.stop();
         service2.stop();
      }
      catch (JMException e)
      {
         fail("creation of two instances failed");
      }
      catch (IOException e)
      {
         fail("creation of two instances failed");
      }
   }
   
   @Test
   public void testGetPlatformService() throws InterruptedException
   {
      try
      {
         JMXService service = JMXService.getInstance(ADDRESS1, PORT6, true);
         assertTrue("MBeanServer should be the platform server",
               service.getJMXConnectorServer().getMBeanServer() ==
                  ManagementFactory.getPlatformMBeanServer());
         service.stop();
      }
      catch (JMException e)
      {
         System.err.println(e);
         fail("creation of two instances failed");
      }
      catch (IOException e)
      {
         System.err.println(e);
         fail("creation of two instances failed");
      }
   }
   
   @Test
   public void testGetPlatformServiceTwoTimes() throws InterruptedException
   {
      try
      {
         JMXService service1 = JMXService.getInstance(ADDRESS1, PORT7, true);
         assertTrue("MBeanServer should be the platform server",
               service1.getJMXConnectorServer().getMBeanServer() ==
                  ManagementFactory.getPlatformMBeanServer());
         try
         {
            JMXService service2 = JMXService.getInstance(ADDRESS1, PORT8, true);
            service2.stop();
            fail("Duplicate platform-server-backed service creation should have failed");
         }
         catch (JMException e)
         {
            service1.stop();
         }
         catch (IOException e)
         {
            service1.stop();
         }
      }
      catch (JMException e)
      {
         e.printStackTrace();
         fail("Creaton of first instance failed");
      }
      catch (IOException e)
      {
         e.printStackTrace();
         fail("Creation of first instance failed");
      }
      
   }
   
   

}


