//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: ivolvovski
//
// Date: Dec 8, 2007
//---------------------

package org.cleversafe.control;
import static org.junit.Assert.*;

import java.util.Map;

import org.cleversafe.test.BaseTest;
import org.junit.Test;

public class FixedPunishmentSelectorTest extends BaseTest
{

   @Test
   public void testSelector()
   {
      IntegerRangeParameter goodState = new IntegerRangeParameter(1,1,10);
      IntegerRangeParameter badState = new IntegerRangeParameter(2,1,10);
      FixedPunishmentSelector selector = new FixedPunishmentSelector(goodState, 3, 1.0);
      assertEquals(selector.getState(), goodState);
      assertEquals(3, selector.getMinimalSingleAttemptCount());
      assertEquals(1.0, selector.getErrorPunishment(), 0.00001);
      
      Map<ParameterState, FixedPunishmentSelector.ParameterRuntime> m1 = selector.getCurrentResults();
      assertEquals(1, m1.size());
      assertEquals(3, m1.get(goodState).getThreshold());
      assertEquals(0, m1.get(goodState).getCumulativeErrors());
      
      selector.onSuccess();
      assertEquals(2, m1.get(goodState).getThreshold());
      selector.onSuccess();
      assertEquals(1, m1.get(goodState).getThreshold());
      selector.onSuccess();
      assertEquals(0, m1.get(goodState).getThreshold());
      
      assertEquals(2, m1.size());

      assertNotNull( m1.get(badState));
      assertEquals(badState, selector.getState());
      assertEquals(3, m1.get(badState).getThreshold());
      assertEquals(0, m1.get(goodState).getCumulativeErrors());
      assertEquals(0, m1.get(badState).getCumulativeErrors());
      
      selector.onFailure();
      assertEquals(2, m1.size());
      assertEquals(goodState, selector.getState());
      assertEquals(0, m1.get(goodState).getCumulativeErrors());
      assertEquals(1, m1.get(badState).getCumulativeErrors());
      
      //System.out.println(m1.get(goodState).getThreshold());
      assertEquals(15, m1.get(goodState).getThreshold());  // 3*(1+3/1+1)
      for (int i=0; i<14; i++) 
      {
         selector.onSuccess();
         assertEquals(goodState, selector.getState());
      }   
      selector.onSuccess();
      assertEquals(badState, selector.getState());
      assertEquals(0, m1.get(goodState).getCumulativeErrors());
      assertEquals(1, m1.get(badState).getCumulativeErrors());
      
      selector.onFailure();
      
      assertEquals(2, m1.get(badState).getCumulativeErrors());
      assertEquals(goodState, selector.getState());
      //System.out.println(m1.get(goodState).getThreshold());
      assertEquals(75, m1.get(goodState).getThreshold());  // 15*(1+3/1+1)     
   }
}


