//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: mmotwani
//
// Date: Aug 19, 2007
//---------------------

package org.cleversafe.config;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import org.cleversafe.config.exceptions.ConfigurationItemNotDefinedException;
import org.junit.Test;

public class SystemPropertiesTest
{
   @Test
   public void testGetValue()
   {
      String propertyKey = "this.is.a.stupid.property";
      String propertyValue = "my system property test";
      System.setProperty(propertyKey, propertyValue);

      SystemProperties properties = new SystemProperties();

      try
      {
         assertEquals(properties.getValue(propertyKey.split("\\.")), propertyValue);
      }
      catch (ConfigurationItemNotDefinedException e)
      {
         fail(e.getMessage());
      }

      System.clearProperty(propertyKey);
   }

   @Test
   public void testGetValuesList()
   {
      String propertyKey = "this.is.a.stupid.property";
      String propertyValue = "my system property test";
      System.setProperty(propertyKey, propertyValue);

      SystemProperties properties = new SystemProperties();

      try
      {
         assertEquals(properties.getValuesList(propertyKey.split("\\.")).get(0), propertyValue);
      }
      catch (ConfigurationItemNotDefinedException e)
      {
         fail(e.getMessage());
      }

      System.clearProperty(propertyKey);
   }

   @Test
   public void testIsSet()
   {
      String propertyKey = "this.is.a.stupid.property";
      String propertyValue = "my system property test";
      System.setProperty(propertyKey, propertyValue);

      SystemProperties properties = new SystemProperties();

      assertTrue(properties.isSet(propertyKey.split("\\.")));

      System.clearProperty(propertyKey);
   }

   @Test(expected = ConfigurationItemNotDefinedException.class)
   public void testGetValueException() throws ConfigurationItemNotDefinedException
   {
      String propertyKey = "this.is.a.random.property";

      SystemProperties properties = new SystemProperties();

      properties.getValue(propertyKey.split("\\."));
   }

   @Test(expected = ConfigurationItemNotDefinedException.class)
   public void testGetValuesListException() throws ConfigurationItemNotDefinedException
   {
      String propertyKey = "this.is.a.random.property";

      SystemProperties properties = new SystemProperties();

      properties.getValuesList(propertyKey.split("\\."));
   }

   @Test
   public void negativeTestIsSet()
   {
      String propertyKey = "this.is.a.random.property";

      SystemProperties properties = new SystemProperties();

      assertFalse(properties.isSet(propertyKey.split("\\.")));
   }
}
