//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: ivolvovski
//
// Date: Jun 12, 2007
//---------------------

package org.cleversafe.config;

import static org.junit.Assert.*;

import org.cleversafe.config.ExecutionContext;
import org.junit.Test;

// TODO: Describe class or interface
public class ExecutionContextTest
{
   private static final String NAME1 = "int1";
 
   @Test
   public void creationTest()
   {
      ExecutionContext ctx = new ExecutionContext();
      ctx.add (NAME1, new Integer(5));
      assertEquals(ctx.contains(NAME1), true);
      assertTrue(ctx.contains("xyz") == false);
      assertTrue(ctx.get().size() == 1);
      try {
         assertEquals(ctx.getValue( NAME1, "intValue"), 5 );
         assertNotSame(ctx.getValue( NAME1, "intValue"), 6 );
         assertEquals(ctx.getValue(NAME1, "compareTo", new Integer(5)), 0);
      }
      catch (Exception ex)
      {
         ex.printStackTrace();
         fail ("Failed to get value");
      }
      try {
         ctx.getValue( NAME1, "intValue1");
         fail ("Failed to get value");
      }
      catch (Exception ex)
      {
         // Should be here
      }
   }
}


