//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: dhendrickson
//
// Date: Nov 5, 2007
//---------------------

package org.cleversafe.config;

import static org.junit.Assert.assertEquals;

import java.util.Properties;

import org.junit.Test;

public class ConfigGeneratorTest
{
   @Test
   public void testGenerate()
   {
      Properties properties = new Properties();
      properties.setProperty("property1", "hello");
      properties.setProperty("property2", "world");
      
      String template = "<XML value=\"${property1}\"><element value=\"${property2}\">${property1}</element></XML>";
      String finalXML = "<XML value=\"hello\"><element value=\"world\">hello</element></XML>";
      
      ConfigGenerator generator = new ConfigGenerator(template, properties);
      String generatedXML = generator.generate();
      
      assertEquals("Generated and expected output do not match", finalXML, generatedXML);
   }
}


