//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: jquigley
//
// Date: Jun 12, 2007
//---------------------

package org.cleversafe.codec.misc;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

import org.cleversafe.codec.Codec;
import org.cleversafe.codec.Decoder;
import org.cleversafe.codec.Encoder;
import org.cleversafe.layer.grid.SourceName;
import org.junit.Test;

public class NullCodecTest
{
   @Test
   public void testEncodeDecode() throws Exception
   {
      List<Codec> codecs = null;
      try
      {
         codecs = getCodecs();
      }
      catch (NoSuchAlgorithmException e)
      {
         e.printStackTrace();
         fail(e.getMessage());
      }

      for (Codec codec : codecs)
      {
         testEncodeDecode(codec);
      }
   }

   public void testEncodeDecode(Codec codec) throws Exception
   {
      Encoder encoder = codec.getEncoder();

      SourceName randomSourceName =
            new SourceName(new Integer((int) (Math.random() * 256)).toString());

      encoder.reset(randomSourceName, 1);
      assertTrue(encoder.isInitialized());

      byte data[] = new byte[4096];
      randomizeBuffer(data);

      byte encodedData[] = encoder.finish(data);

      Decoder decoder = codec.getDecoder();
      decoder.reset(randomSourceName, 1);
      assertTrue(decoder.isInitialized());

      byte decodedData[] = decoder.finish(encodedData);

      for (int idx = 0; idx < data.length; idx++)
      {
         assertEquals(data[idx], decodedData[idx]);
      }
   }

   private List<Codec> getCodecs() throws NoSuchAlgorithmException
   {
      List<Codec> codecs = new ArrayList<Codec>();

      try
      {
         // Null Codec
         NullCodec codec = new NullCodec();
         assertEquals(codec.getName(), "null");
         assertEquals(codec.getType(), "misc");
         assertEquals(codec.getEncoder().finish().length, 0);
         assertEquals(codec.getDecoder().finish().length, 0);
         
         // Add NullCodec to the list
         codecs.add(codec);

      }
      catch (Exception e)
      {
         e.printStackTrace();
         fail(e.getMessage());
      }

      return codecs;
   }

   private static void randomizeBuffer(byte data[])
   {
      for (int idx = 0; idx < data.length; idx++)
      {
         data[idx] = (byte) (Math.random() * 256);
      }
   }

}
