//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: jquigley
//
// Date: Jun 12, 2007
//---------------------

package org.cleversafe.codec.integrity;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import org.cleversafe.codec.Decoder;
import org.cleversafe.codec.Encoder;
import org.cleversafe.layer.grid.SourceName;
import org.junit.Test;

public class CRCIntegrityCodecTest
{
   @Test
   public void testCRCIntegrity()
   {
      CRCIntegrityCodec codec = new CRCIntegrityCodec();

      try
      {
         byte testData[] = "This is a test".getBytes();

         
         Encoder encoder = codec.getEncoder();
         encoder.reset(new SourceName(""), 0);
         byte encodedData[] = encoder.finish(testData);

         assertEquals(testData.length + CRCIntegrityDecoder.CRC_LENGTH, encodedData.length);

         Decoder decoder = codec.getDecoder();
         decoder.reset(new SourceName(""), 0);

         byte decodedData[] = decoder.finish(encodedData);

         assertEquals(new String(testData), new String(decodedData));

         // Corrupt encoded data
         byte corruptedEncodedData[] = new byte[encodedData.length];
         System.arraycopy(encodedData, 0, corruptedEncodedData, 0, corruptedEncodedData.length);
         corruptedEncodedData[3] = 'x';
         
         decoder = codec.getDecoder();
         
         try         
         {
            decoder.finish( corruptedEncodedData );
            fail( "Decode did not throw exception as expected" );
         } catch ( Exception ex )
         {            
         }
                               
      }
      catch (Exception e)
      {
         e.printStackTrace();
         fail(e.getMessage());
      }
   }
}
