//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
// -----------------------
// @author: Dusty Hendrickson
//
// Date: Jun 5, 2008
// ---------------------

package org.cleversafe.codec.header.zero;

import java.util.Arrays;

import org.cleversafe.codec.Encoder;
import org.junit.Assert;
import org.junit.Test;

public class ZeroHeaderEncoderTest
{
   @Test
   public void testFinish() throws Exception
   {
      final Encoder encoder = new ZeroHeaderEncoder();

      final byte[] data = new byte[]{1, 2, 3, 4};

      final byte[] encodedData = encoder.finish(data);

      Assert.assertTrue(Arrays.equals(new byte[]{0, 1, 2, 3, 4}, encodedData));
   }

   @Test
   public void testProcess() throws Exception
   {
      final Encoder encoder = new ZeroHeaderEncoder();

      final byte[] data1 = new byte[]{1, 2, 3, 4};
      final byte[] data2 = new byte[]{5, 6, 7, 8};

      final byte[] processData = encoder.process(data1);
      final byte[] finishData = encoder.finish(data2);

      Assert.assertTrue(Arrays.equals(new byte[]{0, 1, 2, 3, 4}, processData));
      Assert.assertTrue(Arrays.equals(new byte[]{5, 6, 7, 8}, finishData));

   }

   @Test
   public void testReset() throws Exception
   {
      final Encoder encoder = new ZeroHeaderEncoder();

      final byte[] data1 = new byte[]{1, 2, 3, 4};
      final byte[] data2 = new byte[]{5, 6, 7, 8};

      final byte[] processData = encoder.process(data1);
      encoder.reset(null, 0);
      final byte[] finishData = encoder.finish(data2);

      Assert.assertTrue(Arrays.equals(new byte[]{0, 1, 2, 3, 4}, processData));
      Assert.assertTrue(Arrays.equals(new byte[]{0, 5, 6, 7, 8}, finishData));
   }

   @Test
   public void testInitialized()
   {
      final Encoder encoder = new ZeroHeaderEncoder();

      Assert.assertTrue(encoder.isInitialized());
   }
}
