//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
// -----------------------
// @author: Dusty Hendrickson
//
// Date: Jun 5, 2008
// ---------------------

package org.cleversafe.codec.header.zero;

import java.util.Arrays;

import org.cleversafe.codec.Decoder;
import org.cleversafe.codec.Encoder;
import org.cleversafe.codec.header.HeaderCodec;
import org.junit.Assert;
import org.junit.Test;

public class ZeroHeaderCodecTest
{
   @Test
   public void testConstants()
   {
      Assert.assertTrue(Arrays.equals(new byte[]{0x00}, ZeroHeaderCodec.HEADER));
      Assert.assertEquals(1, ZeroHeaderCodec.HEADER_LENGTH);
   }

   @Test
   public void testName()
   {
      final HeaderCodec codec = new ZeroHeaderCodec();

      Assert.assertEquals("zero", codec.getName());
   }

   @Test
   public void testType()
   {
      final HeaderCodec codec = new ZeroHeaderCodec();

      Assert.assertEquals("header", codec.getType());
   }

   @Test
   public void testEncodedSize() throws Exception
   {
      final HeaderCodec codec = new ZeroHeaderCodec();

      for (long a = 0; a < 1024; a++)
      {
         Assert.assertEquals(a + 1, codec.getEncodedSize(a));
      }
   }

   @Test
   public void testEncoder() throws Exception
   {
      final HeaderCodec codec = new ZeroHeaderCodec();

      final Encoder encoder1 = codec.getEncoder();
      Assert.assertTrue(encoder1 != null);

      final Encoder encoder2 = codec.getEncoder();
      Assert.assertTrue(encoder2 != null);

      Assert.assertTrue(encoder1 != encoder2);
   }

   @Test
   public void testDecoder() throws Exception
   {
      final HeaderCodec codec = new ZeroHeaderCodec();

      final Decoder decoder1 = codec.getDecoder();
      Assert.assertTrue(decoder1 != null);

      final Decoder decoder2 = codec.getDecoder();
      Assert.assertTrue(decoder2 != null);

      Assert.assertTrue(decoder1 != decoder2);
   }
}
