//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: Jason Resch
//
// Date: Mar 7, 2008
//---------------------

package org.cleversafe.codec.compatibility;

import org.cleversafe.codec.Codec;
import org.cleversafe.codec.integrity.CRCIntegrityCodec;

public class CRCIntegrityCodecCompatibilityTest extends CodecCompatibilityTestBase
{
   public static final int dataLength = 957;
   public static final byte[] encoded = new byte[] { -42, 32, -97, 92, 49, -77, 97, -125, 34, -87, -40, -18, 120, 7, -56, -22, -114, 121, 69, -43, -119, -17, -92, 9, 127, -22, -109, 83, 100, 64, -22, 31, -101, 73, 75, 60, -6, -58, 11, 9, -70, -97, 95, 89, -68, -27, -16, -4, 60, 55, -75, 114, 45, -37, -15, -23, -55, -3, 93, -93, -32, 99, -105, 29, -58, 39, -124, 40, 126, -12, 3, -18, 9, -39, -43, -60, -49, -4, 60, 67, -110, 85, -16, -15, -33, -110, 17, 37, 80, 46, -54, 16, -88, 29, 2, -108, 57, 81, 107, -49, -5, 40, -20, 86, 66, -87, 88, 122, 110, 8, 39, -67, -2, 97, 36, 85, -98, 101, 92, 72, -29, -69, 73, -79, 11, -42, 4, -90, -117, -7, -115, -22, 83, 47, -40, 110, 110, 27, -46, 89, -105, 20, 6, -17, -32, 46, 26, 23, 78, 54, 42, -28, 100, -74, 46, -114, -39, -123, -108, 114, -120, 116, 79, 26, -116, 64, -26, -46, -25, 119, -63, -15, 13, -62, 69, 41, 13, -2, -75, 49, 56, -108, -109, -92, 72, 108, -26, 64, -25, -62, -24, -10, -83, -120, 49, -78, 80, 36, 41, -107, -35, 26, 30, 12, -40, -102, -78, 15, 77, 123, 98, 51, -120, 99, 13, 123, 24, 41, -93, -39, -113, -36, -24, 99, -83, -111, -28, 101, 110, -31, -123, 57, -44, -102, 78, 59, -62, 118, 76, 41, -36, -122, -16, 39, -50, 21, -95, -125, -14, 67, 15, 17, 45, 8, 112, -124, -18, 114, 73, 26, 87, -2, 102, 1, 36, 63, 110, -105, -38, -17, 80, 29, -19, -49, -75, 96, 126, 114, -61, 38, 8, 126, -29, 126, -93, -99, 58, 50, 13, 90, -49, -104, -95, 81, 103, -43, 120, -58, 90, -23, -11, -26, 111, 102, 34, 63, -12, 22, 112, -17, 11, 87, 32, -79, 122, 48, -42, 99, -114, -1, 86, 81, -41, -122, -120, 98, 86, 30, 80, 125, 68, -10, 40, 24, 92, -79, 22, 49, -44, 122, 96, -103, 78, -80, 18, -50, -68, -125, 46, -19, -17, 43, 76, -94, 7, -50, 104, 89, 56, -23, 127, -92, -70, 123, 79, -65, 41, -48, -45, -128, 123, 0, 111, -116, -38, -85, 78, 43, -5, -101, 26, 4, 119, -78, 39, 8, -71, -107, 68, -128, 35, -60, -83, 39, 110, -79, -118, 76, 45, 40, 92, 98, 11, -92, -96, -4, -34, 19, 83, 35, -104, 31, -118, 39, -108, -64, 81, -78, -25, 8, 66, 83, 29, -36, -43, -93, 36, -45, -70, 40, 76, -60, 37, 13, -113, 108, 92, -50, 56, 94, 57, 3, -108, 46, 115, 23, 89, 44, -24, 22, 82, 103, 45, 33, 89, 6, -56, -67, -107, 74, 9, -118, -15, -63, -107, 54, 37, -83, -18, -66, 42, -99, 40, 73, 89, -85, 79, 113, -106, -111, 64, -107, -81, 75, -14, 59, 122, -119, -87, -56, 44, -114, 95, 88, 25, -93, -117, 92, -18, 98, 8, 29, -62, 66, -34, 50, 98, 0, -102, 92, 96, -107, 94, -24, 40, -92, 35, -71, -69, -83, 112, -68, -24, -82, -19, 33, 35, 44, -42, -33, -119, -107, 61, 17, -22, 9, 46, -100, -111, -122, 86, 71, -52, 111, 125, 105, 124, -107, 119, -62, 31, 85, 103, 124, -44, -36, -90, 31, 95, -40, -68, -18, 43, -49, -124, 118, 111, -10, 123, 45, 89, -111, -120, -78, -7, 67, -115, 34, 120, 100, 72, 118, 8, 31, -81, 109, -47, -34, -63, 73, -121, -100, 116, 63, -106, -104, -69, 66, 119, -125, 65, -38, 6, -17, -72, 14, -72, -2, -81, -80, -77, -116, 19, 88, -36, -28, -68, 93, -82, -105, 57, 124, -106, -94, -84, -102, 125, 100, 34, 127, 41, -58, -115, -81, -45, 92, 117, -88, 91, 108, -70, -10, -77, 94, -4, 80, -104, -81, -43, -72, -60, 55, 77, -85, -81, -26, 3, 54, 38, 125, -36, -48, -110, -128, -128, -14, -115, 7, -49, -92, -109, -10, -70, -97, -30, -38, 71, 64, 113, -96, -107, 16, -106, -89, 0, 40, 7, 33, -112, -34, 64, 86, 114, -111, -2, -34, -49, -114, -8, -78, -37, 13, 83, 3, 107, 113, 3, 2, -32, 27, -25, -88, 109, -14, 35, 13, -102, -12, -1, 52, 89, -13, 82, 28, 79, 119, 75, -32, 70, -43, 57, -117, 51, -17, 30, 62, -62, 110, 17, 127, -44, -96, -21, 88, 31, 14, -4, 10, 37, 41, -17, 113, -35, 47, 51, 122, 68, -50, -4, 55, 64, -118, -13, -12, 115, -126, 83, 45, 101, -54, -83, 97, -42, -109, -2, 123, 68, -84, 50, 125, -16, 103, 55, 78, -117, 70, 101, 84, 6, 64, 10, -49, 49, 68, -34, -23, -67, 107, 50, 85, 46, -87, -118, -101, -69, -111, 97, -72, -56, 116, -59, 5, 16, 98, -82, -23, 72, 75, 94, -87, -85, 44, -80, -26, 29, 26, 2, -111, 54, 6, -52, -46, -85, -76, 123, 22, -2, 111, -59, -27, 105, -123, 32, -81, -38, 107, 126, -112, -18, -19, -5, -36, 49, -109, -62, 70, 30, -94, -26, -54, -121, -64, 21, -55, -95, 125, 22, -124, 61, 45, 19, 91, 59, -40, -65, 72, 107, 33, -10, -85, -57, -124, -72, 116, -9, -119, 68, -49, -31, 63, 84, 91, 93, -119, -65, 50, -123, -82, 12, 123, -70, 113, 50, 5, 38, -6, 38, -25, 32, 27, -8, 10, 22, -25, 101, -79, 66, 71, 70, 59, 41, -61, -128, 51, -23, 75, -102, -85, 1, 14, -86, 17, -38, -97, -17, -78, 102, 17, -87, 29, 30, -78, -4, 47, -114, 23, 121, -126, -70, -71, 75, -31, 75, 86, -63, 32, 96, -32, -64, -97, 100 };
   
   public CRCIntegrityCodecCompatibilityTest()
   {
      super(encoded, dataLength);
   }
   
   @Override
   public Codec getCodec()
   {
      return new CRCIntegrityCodec();
   }
   
}
