//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: Zachary Mark
//
// Date: Jun 28, 2007
//---------------------

package org.cleversafe.authentication.credentials;

import static org.junit.Assert.assertEquals;

import java.util.UUID;

import org.cleversafe.authentication.credentials.PasswordCredentials;
import org.cleversafe.util.UUIDGen;
import org.junit.BeforeClass;
import org.junit.Test;



/**
 * Test for the (mostly trivial) PasswordCredentials container class.
 *
 * @author Zachary Mark
 */
public class PasswordCredentialsTest
{
   private static final String ACCOUNT_USERNAME = "testuser";
   private static final String ACCOUNT_PASSWORD = "testpass";

   @BeforeClass
   public static void setUpBeforeClass() throws Exception
   {
   }
   
   /** 
    * This test case examines the get/set methods to make sure that the returned values are
    * the same as the ones given, and that the UUID is generated properly.
    *
    */
   @Test
   public void testGettersSetters()
   {
      PasswordCredentials credentials = new PasswordCredentials();
            
      credentials.setUsername(ACCOUNT_USERNAME);
      credentials.setPassword(ACCOUNT_PASSWORD);
      
      UUID accountID = UUIDGen.getUUIDFromUsername(ACCOUNT_USERNAME);
      
      assertEquals("Usernames not equal!", ACCOUNT_USERNAME, credentials.getUsername());
      assertEquals("Passwords not equal!", ACCOUNT_PASSWORD, credentials.getPassword());
      assertEquals("UUIDs not equal!", accountID, credentials.getAccountIdentifier());
   }
   

}


