//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: dhendrickson
//
// Date: May 29, 2007
//---------------------

package org.cleversafe.authentication.authenticators;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.BasicConfigurator;
import org.cleversafe.UnitTests;
import org.cleversafe.authentication.credentials.PasswordCredentials;
import org.cleversafe.layer.communication.Connector;
import org.cleversafe.layer.communication.network.policy.TestApplicationConnection;
import org.cleversafe.layer.protocol.PasswordAuthenticationRequest;
import org.cleversafe.layer.protocol.PasswordAuthenticationResponse;
import org.cleversafe.layer.protocol.Request;
import org.cleversafe.layer.protocol.Response;
import org.junit.BeforeClass;
import org.junit.Test;

/**
 * A test of the PasswordAuthenticator object. Tests setting credentials and authenticating against
 * a ServerApplication.
 * 
 * @see PasswordAuthenticator
 * @author Dusty Hendrickson
 */
public class PasswordAuthenticatorTest
{
   @BeforeClass
   public static void setUpBeforeClass() throws Exception
   {
      BasicConfigurator.configure();
      UnitTests.resetConfiguration();
   }

   @Test
   public void testCredentials()
   {
      PasswordCredentials testCreds = new PasswordCredentials();
      testCreds.setUsername("username");
      testCreds.setPassword("password");

      PasswordAuthenticator authenticator = new PasswordAuthenticator(null);
      authenticator.setCredentials(testCreds);

      PasswordCredentials creds = (PasswordCredentials) authenticator.getCredentials();

      assertEquals("Credentials do not match", testCreds, creds);
   }

   @Test
   public void testSuccessfulLogin()
   {
      boolean login = false;

      try
      {
         PasswordCredentials credentials = new PasswordCredentials();
         credentials.setUsername("TestUser1");
         credentials.setPassword("IAmTestUser1");

         PasswordAuthenticationRequest authenticationRequest = new PasswordAuthenticationRequest();
         authenticationRequest.setUsername(credentials.getUsername());
         authenticationRequest.setPassword(credentials.getPassword());
         authenticationRequest.setGridAccountID(credentials.getAccountIdentifier());

         PasswordAuthenticationResponse passwordAuthenticationResponse;
         passwordAuthenticationResponse = new PasswordAuthenticationResponse();
         passwordAuthenticationResponse.setAuthenticated(true);

         Response authenticationResponse = new PasswordAuthenticationResponse();
         authenticationResponse = passwordAuthenticationResponse;

         List<Request> requestList = new ArrayList<Request>();
         List<Response> responseList = new ArrayList<Response>();
         requestList.add(authenticationRequest);
         responseList.add(authenticationResponse);

         Connector conn = new TestApplicationConnection(requestList, responseList);
         TestApplicationConnection testConn = (TestApplicationConnection) conn;

         PasswordAuthenticator authenticator = new PasswordAuthenticator(conn);
         authenticator.setCredentials(credentials);

         login = authenticator.login();
         assertEquals("Malformed Message Sent", testConn.lastRequestMalformed(), false);

         conn.disconnect();
      }
      catch (Exception ex)
      {
         ex.printStackTrace();
         login = false;
      }

      assertTrue("Unexpected login failure", login);
   }

   @Test
   public void testUnsuccessfulLogin()
   {
      boolean login = false;

      try
      {
         PasswordCredentials credentials = new PasswordCredentials();
         credentials.setUsername("not-a-user");
         credentials.setPassword("not-a-password");

         PasswordAuthenticationRequest authenticationRequest = new PasswordAuthenticationRequest();
         authenticationRequest.setUsername(credentials.getUsername());
         authenticationRequest.setPassword(credentials.getPassword());
         authenticationRequest.setGridAccountID(credentials.getAccountIdentifier());

         PasswordAuthenticationResponse passwordAuthenticationResponse;
         passwordAuthenticationResponse = new PasswordAuthenticationResponse();
         passwordAuthenticationResponse.setAuthenticated(false);

         Response authenticationResponse = new PasswordAuthenticationResponse();
         authenticationResponse = passwordAuthenticationResponse;

         List<Request> requestList = new ArrayList<Request>();
         List<Response> responseList = new ArrayList<Response>();
         requestList.add(authenticationRequest);
         responseList.add(authenticationResponse);

         Connector conn = new TestApplicationConnection(requestList, responseList);
         TestApplicationConnection testConn = (TestApplicationConnection) conn;

         PasswordAuthenticator authenticator = new PasswordAuthenticator(conn);
         authenticator.setCredentials(credentials);

         login = authenticator.login();
         assertEquals("Malformed Message Sent", testConn.lastRequestMalformed(), false);

         conn.disconnect();
      }
      catch (Exception ex)
      {
         login = false;
      }

      assertTrue("Unexpected login success", !login);
   }
}
