//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: wleggette
//
// Date: Jul 13, 2007
//---------------------

package org.cleversafe;

import java.io.File;
import java.util.UUID;

import org.cleversafe.authentication.PropertiesFileCredentialsManager;
import org.cleversafe.test.BaseTest;
import org.cleversafe.util.UUIDGen;

// TODO: Describe class or interface
public class TestDataLiterals
{

   public static final String TEST_DATA_AUTHENTICATION =
         System.getProperty(BaseTest.TEST_INPUT_PROPERTY, ".") + "/org/cleversafe/authentication";

   public static final String TEST_DATA_VAULT =
         System.getProperty(BaseTest.TEST_INPUT_PROPERTY, ".") + "/org/cleversafe/vault";

   public static final String FIXED_CREDENTIALS_FILE_NAME =
         "d2577a28-443c-33bf-9c8f-d3cb14961d16.credentials";
   public static final String FIXED_KEYSTORE_FILE_NAME = "d2577a28-443c-33bf-9c8f-d3cb14961d16.jks";

   public static final String FIXED_DESCRIPTOR_FILE_NAME =
         "00000000-0000-0000-0000-000000000000.xml";

   public static final String FIXED_ACL_FILE_NAME = "00000000-0000-0000-0000-000000000000.acl";

   public static final String FIXED_CREDENTIALS_FILE_PATH =
         TEST_DATA_AUTHENTICATION + File.separator + FIXED_CREDENTIALS_FILE_NAME;

   public static final String FIXED_KEYSTORE_FILE_PATH =
         TEST_DATA_AUTHENTICATION + File.separator + FIXED_KEYSTORE_FILE_NAME;

   public static final String FIXED_DESCRIPTOR_FILE_PATH =
         TEST_DATA_VAULT + File.separator + FIXED_DESCRIPTOR_FILE_NAME;

   public static final String FIXED_ACL_FILE_PATH =
         TEST_DATA_VAULT + File.separator + FIXED_ACL_FILE_NAME;

   public static final String FIXED_ACCOUNT_USERNAME = "griduser";
   public static final String FIXED_ACCOUNT_PASSWORD = "blogosphere";
   public static final UUID FIXED_ACCOUNT_UUID =
         UUIDGen.getUUIDFromUsername(FIXED_ACCOUNT_USERNAME);

   public static final String TEST_CREDENTIALS_FILE_NAME = "test.credentials";
   public static final String TEST_KEYSTORE_FILE_NAME = "test.jks";

   public static final String TEST_DESCRIPTOR_FILE_NAME = "test.xml";

   public static final String TEST_ACL_FILE_NAME = "test.acl";

   public static final String TEST_CREDENTIALS_FILE_PATH =
         TEST_DATA_AUTHENTICATION + File.separator + TEST_CREDENTIALS_FILE_NAME;

   public static final String TEST_KEYSTORE_FILE_PATH =
         TEST_DATA_AUTHENTICATION + File.separator + TEST_KEYSTORE_FILE_NAME;

   public static final String TEST_DESCRIPTOR_FILE_PATH =
         TEST_DATA_VAULT + File.separator + TEST_DESCRIPTOR_FILE_NAME;

   public static final String TEST_ACL_FILE_PATH =
         TEST_DATA_VAULT + File.separator + TEST_ACL_FILE_NAME;

   public static final String TEST_ACCOUNT_USERNAME = "testuser";
   public static final String TEST_ACCOUNT_PASSWORD = "testpass";
   public static final UUID TEST_ACCOUNT_UUID = UUIDGen.getUUIDFromUsername(TEST_ACCOUNT_USERNAME);

   /**
    * Sets the credentials and keystore path properties to the path of the "fixed credentials" test
    * files.
    */
   public static void setFixedCredentialsProperties()
   {
      System.setProperty(PropertiesFileCredentialsManager.SYSTEM_PROPERTY_CREDENTIALS_PATH,
            FIXED_CREDENTIALS_FILE_PATH);
      System.setProperty(PropertiesFileCredentialsManager.SYSTEM_PROPERTY_KEYSTORE_PATH,
            FIXED_KEYSTORE_FILE_PATH);
   }

   /**
    * Sets the credentials and keystore path properties to the path of the "test credentials" test
    * files.
    */
   public static void setTestCredentialsProperties()
   {
      System.setProperty(PropertiesFileCredentialsManager.SYSTEM_PROPERTY_CREDENTIALS_PATH,
            TEST_CREDENTIALS_FILE_PATH);
      System.setProperty(PropertiesFileCredentialsManager.SYSTEM_PROPERTY_KEYSTORE_PATH,
            TEST_KEYSTORE_FILE_PATH);
   }

   /**
    * Clears all credentials related system properties.
    */
   public static void clearCredentialsProperties()
   {
      System.clearProperty(PropertiesFileCredentialsManager.SYSTEM_PROPERTY_CREDENTIALS_PATH);
      System.clearProperty(PropertiesFileCredentialsManager.SYSTEM_PROPERTY_KEYSTORE_PATH);
      System.clearProperty(PropertiesFileCredentialsManager.SYSTEM_PROPERTY_DEFAULT_PATH);
   }


}
