
package org.cleversafe.test;

import java.util.concurrent.*;

public class ThreadedPerformanceTester implements PerformanceTester
{
   // Number of milliseconds per second
   private static final double MS_PER_SEC = 1000;

   private int threadPoolSize;

   public ThreadedPerformanceTester(int threadPoolSize)
   {
      this.threadPoolSize = threadPoolSize;
   }

   public PerformanceTestResult run(WorkItemProvider workItemProvider, long targetWorkUnits)
         throws Exception
   {
      long workItemId = 0;

      double workUnitsCompleted = 0;

      long startTime = System.currentTimeMillis();

      ExecutorService executor = Executors.newFixedThreadPool(threadPoolSize);

      while (workUnitsCompleted < targetWorkUnits)
      {
         WorkItem workItem = workItemProvider.createWorkItem(workItemId++);

         executor.execute(workItem);
         workUnitsCompleted += workItem.getWorkUnits();
      }

      executor.shutdown();

      boolean finished = false;
      do
      {
         try
         {
            finished = executor.awaitTermination(10, TimeUnit.SECONDS);
         }
         catch (InterruptedException e)
         {
            e.printStackTrace();
         }
      } while (!finished);

      long endTime = System.currentTimeMillis();

      double executionTime = (endTime - startTime) / MS_PER_SEC;

      return new PerformanceTestResult(executionTime, workUnitsCompleted);
   }

}
