
package org.cleversafe.test;

public class SimplePerformanceTester implements PerformanceTester
{
   // Number of milliseconds per second
   private static final double MS_PER_SEC = 1000;

   public PerformanceTestResult run(WorkItemProvider workItemProvider, long targetWorkUnits)
         throws Exception
   {
      long workItemId = 0;

      double workUnitsCompleted = 0;

      long startTime = System.currentTimeMillis();

      while (workUnitsCompleted < targetWorkUnits)
      {
         WorkItem workItem = workItemProvider.createWorkItem(workItemId++);

         workItem.run();
         workUnitsCompleted += workItem.getWorkUnits();
      }

      long endTime = System.currentTimeMillis();
      double executionTime = (endTime - startTime) / MS_PER_SEC;
      
      return new PerformanceTestResult(executionTime, workUnitsCompleted);
   }

}
