//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: jquigley
//
// Date: Sep 17, 2007
//---------------------

package org.cleversafe.layer.network;

import org.cleversafe.layer.protocol.NoopRequest;
import org.cleversafe.layer.protocol.Request;
import org.cleversafe.server.ClientSession;
import org.cleversafe.server.ServerApplication;
import org.cleversafe.server.handlers.misc.NoopHandlerNoEcho;

/**
 * NoopServerApplication implements a simple server which sends noop responses
 * 
 * @see GridServerApplication
 * @see ServerApplication
 * @author Jason Resch
 * 
 */
public class NoopServerApplication extends ServerApplication
{
   /**
    * Default Constructor
    */
   public NoopServerApplication()
   {
      _addHandlers();
   }

   /**
    * Registers all handlers for the recognized protocol messages
    */
   private void _addHandlers()
   {
      // Miscellaneous handlers
      addHandler(new NoopHandlerNoEcho());
   }
   
   /**
    * Verify that a protocol message is compatible with the Server as defined in its
    * configuration.
    * 
    * @see SliceServerApplicationImpl.verifyProtocolVersionInMessage
    */
   public boolean verifyProtocolVersionsInMessage(Request request, ClientSession session)
   {
      return (request instanceof NoopRequest);
   }
}
