//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: Jason Resch
//
// Date: Apr 27, 2007
//---------------------

package org.cleversafe.codec;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

/**
 * This class implements a simple benchmark for testing the performance of
 * AES-128 encryption. It attempts to compress as many 8 KB blocks as possible
 * in 10 seconds.
 * 
 */
public class CipherBenchmark
{

   public static void main(String[] args) throws Exception
   {

      byte[] message = new byte[8192];

      // Get the KeyGenerator
      KeyGenerator keyGen = KeyGenerator.getInstance("AES");
      keyGen.init(128);

      // Generate the secret key specs.
      SecretKey secretKey = keyGen.generateKey();
      byte[] key = secretKey.getEncoded();

      SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");

      // Instantiate the cipher
      Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
      cipher.init(Cipher.ENCRYPT_MODE, skeySpec);

      System.out.println("Encrypting data for 10 seconds...");
      System.out.println("");

      int count = 0;
      long period = 10000; // 10 seconds = 10000 millis
      long startTime = System.currentTimeMillis();

      // Loop performing encryption
      while (System.currentTimeMillis() < startTime + period)
      {
         cipher.doFinal(message);
         count++;
      }

      System.out.println("Encrypted: " + (message.length * count / 10)
            + " bytes of data per second");

   }
}