//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: ivolvovski
//
// Date: May 24, 2007
//---------------------

package org.cleversafe.daemon;

import java.util.Arrays;
import java.util.Date;

import org.apache.log4j.Logger;

// TODO: Describe class or interface
public class DaemonizerTest extends Daemonizer
{
   private static final Logger logger = Logger.getLogger(DaemonizerTest.class);
   
   private boolean shutdown;
   private Object latch = new Object();
   private int sleepTime = 1000;
   private int shutdownTime = 1000;

   public static void main(String[] args)
   {
      new DaemonizerTest(args).run();
   }

   public DaemonizerTest(String[] params)
   {
      super();
      if (params == null)
         System.out.println("No parameters specified");
      else
         System.out.println(Arrays.asList(params));

      if (params != null)
      {
         if (params.length >= 1)
         {
            this.sleepTime = Integer.parseInt(params[0]);
         }
         if (params.length >= 2)
         {
            this.shutdownTime = Integer.parseInt(params[1]);
         }
      }
   }

   private void run()
   {
      while (!this.shutdown)
      {
         logger.info("Running at " + new Date());
         try
         {
            synchronized (this.latch)
            {
               this.latch.wait(this.sleepTime);
            }
         }
         catch (InterruptedException ignore)
         {
            logger.info(" Main loop:" + ignore + " ===> " + new Date());
         }
      }
      logger.info("Exiting application at: " + new Date());

   }

   @Override
   public void shutdown()
   {
      logger.info("Shutdown requested at: " + new Date());

      try
      {
         logger.info("Imitating shutdown " + new Date());
         logger.info("Should take: " + this.shutdownTime/1000 + "sec");
         logger.info(this.shutdownTime);
         logger.info("Shutdown complete at" + new Date());

      }
      catch (Exception ignore)
      {
         ignore.printStackTrace();
      }

      synchronized (this.latch)
      {
         this.shutdown = true;
         this.latch.notify();
      }
   }
}
