//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: mmotwani
//
// Date: Jun 7, 2007
//---------------------

package org.cleversafe.vault;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Method;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import org.apache.log4j.Logger;
import org.cleversafe.authentication.credentials.PasswordCredentials;
import org.cleversafe.config.ExecutionContext;
import org.cleversafe.vault.VaultACL.Entry;
import org.cleversafe.vault.storage.VaultKeyInfo;
import org.junit.BeforeClass;
import org.junit.Test;

// TODO: Describe class or interface
public class XMLVaultLoaderTest
{
   private static Logger _logger = Logger.getLogger(XMLVaultLoaderTest.class);

   private static final String VAULT_DESC_FILE_NAME =
         "test-data/org/cleversafe/vault/Vault-desc.xml";
   private static final String SYTEM_CONFIG_FILE_NAME = "test-data/org/cleversafe/vault/config.xml";

   @BeforeClass
   public static void runBeforeTests()
   {
      System.setProperty("org.cleversafe.xml.configuration", SYTEM_CONFIG_FILE_NAME);
   }

   @Test
   public void testXMLVaultLoader()
   {
      try
      {
         UUID vaultIdentifier = UUID.randomUUID();

         PasswordCredentials credentials = new PasswordCredentials();
         credentials.setUsername("vaultloadertest");
         credentials.setPassword("password");

         _logger.debug("Creating Vault ACL for account: "
               + credentials.getAccountIdentifier().toString());

         KeyPairGenerator keygen = KeyPairGenerator.getInstance("RSA");
         keygen.initialize(2048);
         KeyPair keypair = keygen.generateKeyPair();

         List<VaultKeyInfo> keyInfoList = new ArrayList<VaultKeyInfo>();

         // Creating the Vault ACL
         VaultACLFactory fact = new VaultACLFactory();
         ByteArrayOutputStream out = new ByteArrayOutputStream();
         fact.create(out, vaultIdentifier, credentials, keypair.getPublic(), keyInfoList);
         ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
         VaultACL vaultACL = fact.getInstance(in);

         // Clear memory
         out.reset();
         in.reset();

         Entry entry = vaultACL.getEntry(vaultACL.getOwner(), keypair.getPrivate());

         ExecutionContext ctx = new ExecutionContext();
         ctx.add(VaultDescriptor.ACL_CTX_STRING, vaultACL);
         ctx.add(VaultDescriptor.ACL_ENTRY_CTX_STRING, entry);
         ctx.add(VaultDescriptor.CREDENTIALS_CTX_STRING, credentials);

         Vault vault = new XMLVaultLoader().loadVaultFromXML(VAULT_DESC_FILE_NAME, ctx);

         // Check vault type and parameters
         assertEquals(vault.getType(), "BlockDevice");
         assertEquals(vault.getInformationDispersalCodec().getNumSlices(), 16);
         assertEquals(vault.getInformationDispersalCodec().getThreshold(), 12);
         assertEquals(vault.getInformationDispersalCodec().getClass(),
               org.cleversafe.ida.cauchy.CauchyInformationDispersalCodec.class);
         assertEquals(vault.getSliceStores().size(), 16);

         for (int i = 0; i < 16; i++)
         {
            assertEquals(vault.getSliceStores().get(i).getClass(),
                  org.cleversafe.layer.slicestore.block.BlockMultiFileSliceStore.class);
         }

         // Block specific parameters
         Method m = vault.getClass().getMethod("getBlockSize");
         assertEquals(((Integer) m.invoke(vault)).intValue(), 4096);

         m = vault.getClass().getMethod("getNumBlocks");
         assertEquals(((Long) m.invoke(vault)).longValue(), (long) 104857600);

      }
      catch (Exception e)
      {
         e.printStackTrace();
         _logger.error(e.getMessage(), e);
         fail(e.getMessage());
      }
   }
}
