//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: mmotwani
//
// Date: Jul 9, 2007
//---------------------

package org.cleversafe.vault;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import org.cleversafe.vault.Vault;
import org.junit.BeforeClass;
import org.junit.Test;

// TODO: Describe class or interface
public class FullAccountCreatorTest
{
   private static final String VAULT_DESC_FILE_NAME =
         "test-data/org/cleversafe/vault/local-bdb-vault-descriptor.xml";
   private static final String SYTEM_CONFIG_FILE_NAME =
         "test-data/org/cleversafe/vault/config.xml";

   @BeforeClass
   public static void runBeforeTests()
   {
      System.setProperty("org.cleversafe.xml.configuration", SYTEM_CONFIG_FILE_NAME);
   }

   @Test
   public void testAccountCreation()
   {
      try
      {
         FullAccountCreator fac = new FullAccountCreator(VAULT_DESC_FILE_NAME);

         Vault vault = fac.getVault();

         vaultLoadAsserts(vault);

         fac.cleanup();
      }
      catch (Exception e)
      {
         e.printStackTrace();
         fail(e.toString());
      }
   }

   private void vaultLoadAsserts(Vault vault) throws NoSuchMethodException, IllegalAccessException,
         InvocationTargetException
   {
      // Check vault type and parameters
      assertEquals(vault.getType(), "block");
      assertEquals(vault.getInformationDispersalCodec().getNumSlices(), 16);
      assertEquals(vault.getInformationDispersalCodec().getThreshold(), 12);
      assertEquals(vault.getInformationDispersalCodec().getClass(),
            org.cleversafe.ida.cauchy.CauchyInformationDispersalCodec.class);
      assertEquals(vault.getSliceStores().size(), 16);

      for (int i = 0; i < 16; i++)
      {
         assertEquals(vault.getSliceStores().get(i).getClass(),
               org.cleversafe.layer.slicestore.block.BlockMultiFileSliceStore.class);
      }

      // Block specific parameters
      Method m = vault.getClass().getMethod("getBlockSize");
      assertEquals(((Integer) m.invoke(vault)).intValue(), 4096);

      m = vault.getClass().getMethod("getNumBlocks");
      assertEquals(((Long) m.invoke(vault)).longValue(), (long) 262144);

   }

}
