//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: wleggette
//
// Date: May 25, 2007
//---------------------

package org.cleversafe.server.handlers.authentication;

import static org.junit.Assert.assertTrue;

import java.io.FileInputStream;
import java.util.Properties;
import java.util.UUID;

import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.cleversafe.authentication.loginmodules.AlwaysAuthenticateLoginModule;
import org.cleversafe.layer.protocol.PasswordAuthenticationRequest;
import org.cleversafe.layer.protocol.PasswordAuthenticationResponse;
import org.cleversafe.server.ClientSession;
import org.junit.BeforeClass;
import org.junit.Test;


/**
 * A test of the PasswordAuthenticationHandler using the AlwaysAuthenticateLoginModule JAAS module. 
 * Tests several different account types, confirming that all accounts authenticate successfully.
 * 
 * @see PasswordAuthenticationHandler
 * @see AlwaysAuthenticateLoginModule
 * @author Dusty Hendrickson
 */
public class AlwaysAuthenticateAuthenticationTest
{
   private static Logger _logger = Logger.getLogger(AlwaysAuthenticateAuthenticationTest.class);
   
   private static String jaasConfigFile;
   private static String jaasProfile;

   /**
    * Loads test properties, including JAAS configuration information. Also initializes logging.
    * The system property org.cleversafe.test.config should point to the directory where 
    * AlwaysAuthenticateAuthenticationTest.properties is located.
    * 
    * @throws Exception
    *            If AlwaysAuthenticateAuthenticationTest.properties could not be loaded.
    */
   @BeforeClass
   public static void setUpBeforeClass() throws Exception
   {
      Properties config = new Properties();

      // Load test properties
      String configFile = "";
      try
      {
         configFile =
               //System.getProperty("org.cleversafe.test.config")
               
            "/Users/joshuamullin/Cleversafe/EclipseWorkspace/AccountControl/misc/test"+ System.getProperty("file.separator")
                     + "AlwaysAuthenticateAuthenticationTest.properties";

         config.load(new FileInputStream(configFile));
      }
      catch (Exception ex)
      {
         throw new Exception("Could not open open config file " + configFile);
      }

      // Setup logging
//      String logPropertyFile = config.getProperty("log-properties");
//      if (logPropertyFile != null)
//      {
         PropertyConfigurator.configure("/Users/joshuamullin/Cleversafe/EclipseWorkspace/AccountControl/misc/logger/logger.properties");
//      }
   //   else
    ///  {
     //    BasicConfigurator.configure();
     // }

      // Setup test parameters
      jaasConfigFile = config.getProperty("jaas-config");
      jaasProfile = config.getProperty("jaas-profile");
   }

   /**
    * Confirms that a username and password will authenticate.
    * 
    */
   @Test
   public void testValidUsernamePassword()
   {
      _logger.info("Test Case: valid username and password");
      
      boolean isAuthenticated = false;

      PasswordAuthenticationRequest request = null;
      PasswordAuthenticationResponse response = null;
      
  //    try
 //     {
         request = new PasswordAuthenticationRequest();
         request.setUsername("username");
         request.setPassword("password");
         request.setGridAccountID(new UUID(0,0));
         
         ClientSession session = new ClientSession();

         PasswordAuthenticationHandler handler;
         handler = null; //new PasswordAuthenticationHandler(jaasProfile, jaasConfigFile);

         response = (PasswordAuthenticationResponse) handler.service(request, session);

         isAuthenticated = response.getAuthenticated();
 //     }
/*      catch (Exception ex)
      {
         isAuthenticated = false;
      }*/

      assertTrue("Authentication failed unexpectedly", isAuthenticated);
   }
   
   /**
    * Confirms that a non-UUID grid account ID will not authenticate.
    * 
    */
   @Test
   public void testInvalidGridAccountID()
   {
      _logger.info("Test Case: invalid password");
      
      boolean isAuthenticated = false;
      PasswordAuthenticationRequest request = null;
      PasswordAuthenticationResponse response = null;

      try
      {
         request = new PasswordAuthenticationRequest();
         request.setUsername("username");
         request.setPassword("password");
         request.setGridAccountID(null);

         ClientSession session = new ClientSession();

         PasswordAuthenticationHandler handler;
         handler = null; //new PasswordAuthenticationHandler(jaasProfile, jaasConfigFile);

         response = (PasswordAuthenticationResponse) handler.service(request, session);

         isAuthenticated = response.getAuthenticated();
      }
      catch (Exception ex)
      {
         isAuthenticated = false;
      }

      assertTrue("Authentication succeeded unexpectedly", !isAuthenticated);
   }
}
