package org.cleversafe.protocol;

import org.cleversafe.layer.protocol.Request;
import org.cleversafe.layer.protocol.Response;
import org.cleversafe.layer.protocol.RollbackTransactionRequest;
import org.cleversafe.layer.protocol.RollbackTransactionResponse;
import org.junit.Before;

public class RollbackTransactionProtocolTest extends ProtocolVerificationTest
{
   final private byte[] requestBytes = {0, -54, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
   final private byte[] responseBytes  = {0, -54, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 18, 0, 0, 0, 0, 0};
   
   @Before
   public void setup()
   {
      super.registerRequestBytes(requestBytes);
      super.registerResponseBytes(responseBytes);
   }
   
   public Request createRequest()
   {
      RollbackTransactionRequest request = new RollbackTransactionRequest();
   
      request.setTransactionID(1L);
      
      return request;
   }
   
   public Response createResponse()
   {
      RollbackTransactionResponse response = new RollbackTransactionResponse();
   
      return response;
   }
}