package org.cleversafe.protocol;

import java.util.UUID;

import org.cleversafe.layer.protocol.RemoveStoreRequest;
import org.cleversafe.layer.protocol.RemoveStoreResponse;
import org.cleversafe.layer.protocol.Request;
import org.cleversafe.layer.protocol.Response;
import org.junit.Before;

public class RemoveStoreProtocolTest extends ProtocolVerificationTest
{
   final private byte[] requestBytes = {0, -54, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 33, 0, 0, 0, 0, 0, 36, 48, 48, 48, 48, 48, 48, 48, 48, 45, 48, 48, 48, 48, 45, 48, 48, 48, 55, 45, 48, 48, 48, 48, 45, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 98};
   final private byte[] responseBytes  = {0, -54, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 34, 0, 0, 0, 0, 0};
   
   @Before
   public void setup()
   {
      super.registerRequestBytes(requestBytes);
      super.registerResponseBytes(responseBytes);
   }
   
   public Request createRequest()
   {
      RemoveStoreRequest request = new RemoveStoreRequest();
      
      request.setVaultIdentifier(new UUID(7L,11L));
      
      return request;
   }
   
   public Response createResponse()
   {
      RemoveStoreResponse response = new RemoveStoreResponse();
      
      return response;
   }
}