package org.cleversafe.protocol;

import java.util.ArrayList;
import java.util.List;

import org.cleversafe.layer.grid.DataSlice;
import org.cleversafe.layer.grid.SliceName;
import org.cleversafe.layer.protocol.MultipleWriteRequest;
import org.cleversafe.layer.protocol.MultipleWriteResponse;
import org.cleversafe.layer.protocol.Request;
import org.cleversafe.layer.protocol.Response;
import org.junit.Before;

public class MultipleWriteProtocolTest extends ProtocolVerificationTest
{
   final private byte[] requestBytes = {0, -54, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 21, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 1, 0, 1, 65, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 115, 108, 105, 99, 101, 49, 0, 0, 0, 3, 0, 1, 66, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 6, 115, 108, 105, 99, 101, 50, 0, 0, 0, 5, 0, 1, 67, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 6, 115, 108, 105, 99, 101, 51, 0};
   final private byte[] responseBytes  = {0, -54, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 22, 0, 0, 0, 0, 0};
   
   @Before
   public void setup()
   {
      super.registerRequestBytes(requestBytes);
      super.registerResponseBytes(responseBytes);
   }
   
   public Request createRequest()
   {
      MultipleWriteRequest request = new MultipleWriteRequest();
   
      request.setAllowOverwriteNewer(false);
      
      List<DataSlice> dataSlices = new ArrayList<DataSlice>();
      dataSlices.add(new DataSlice(new SliceName("A",1),0L, "slice1".getBytes()));
      dataSlices.add(new DataSlice(new SliceName("B",3),2L, "slice2".getBytes()));
      dataSlices.add(new DataSlice(new SliceName("C",5),4L, "slice3".getBytes()));
      request.setDataSlices(dataSlices);
      
      return request;
   }
   
   public Response createResponse()
   {
      MultipleWriteResponse response = new MultipleWriteResponse();
      
      return response;
   }
}