package org.cleversafe.protocol;

import java.util.ArrayList;
import java.util.List;

import org.cleversafe.layer.grid.DataSlice;
import org.cleversafe.layer.grid.SliceName;
import org.cleversafe.layer.protocol.MultipleReadRequest;
import org.cleversafe.layer.protocol.MultipleReadResponse;
import org.cleversafe.layer.protocol.Request;
import org.cleversafe.layer.protocol.Response;
import org.junit.Before;

public class MultipleReadProtocolTest extends ProtocolVerificationTest
{
   final private byte[] requestBytes = {0, -54, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 19, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 1, 0, 1, 65, 0, 0, 0, 0, 3, 0, 1, 66, 0, 0, 0, 0, 5, 0, 1, 67, 0};
   final private byte[] responseBytes  = {0, -54, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 1, 0, 1, 65, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 115, 108, 105, 99, 101, 49, 0, 0, 0, 3, 0, 1, 66, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 6, 115, 108, 105, 99, 101, 50, 0, 0, 0, 5, 0, 1, 67, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 6, 115, 108, 105, 99, 101, 51};
   
   @Before
   public void setup()
   {
      super.registerRequestBytes(requestBytes);
      super.registerResponseBytes(responseBytes);
   }
   
   public Request createRequest()
   {
      MultipleReadRequest request = new MultipleReadRequest();
   
      List<SliceName> sliceNames = new ArrayList<SliceName>();
      sliceNames.add(new SliceName("A",1));
      sliceNames.add(new SliceName("B",3));
      sliceNames.add(new SliceName("C",5));
      request.setSliceNames(sliceNames);
      
      return request;
   }
   
   public Response createResponse()
   {
      MultipleReadResponse response = new MultipleReadResponse();
     
      List<DataSlice> dataSlices = new ArrayList<DataSlice>();
      dataSlices.add(new DataSlice(new SliceName("A",1),0L, "slice1".getBytes()));
      dataSlices.add(new DataSlice(new SliceName("B",3),2L, "slice2".getBytes()));
      dataSlices.add(new DataSlice(new SliceName("C",5),4L, "slice3".getBytes()));
      response.setDataSlices(dataSlices);
      
      return response;
   }
}