package org.cleversafe.protocol;

import java.util.ArrayList;
import java.util.List;

import org.cleversafe.layer.grid.SourceName;
import org.cleversafe.layer.protocol.IntegrityVerificationRequest;
import org.cleversafe.layer.protocol.IntegrityVerificationResponse;
import org.cleversafe.layer.protocol.Request;
import org.cleversafe.layer.protocol.Response;
import org.cleversafe.layer.slicestore.SliceInfo;
import org.junit.Before;

public class IntegrityVerificationProtocolTest extends ProtocolVerificationTest
{
   final private byte[] requestBytes = {0, -54, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 53, 0, 0, 0, 0, 0, 0, 0, 3, 0, 1, 65, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 66, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 1, 67, 0, 0, 0, 0, 0, 0, 0, 0, 3};
   final private byte[] responseBytes  = {0, -54, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 54, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 1, 65, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 66, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 1, 67, 0, 0, 0, 0, 0, 0, 0, 0, 3};
   
   @Before
   public void setup()
   {
      super.registerRequestBytes(requestBytes);
      super.registerResponseBytes(responseBytes);
   }
   
   public Request createRequest()
   {
      IntegrityVerificationRequest request = new IntegrityVerificationRequest();
   
      List<SliceInfo> slices = new ArrayList<SliceInfo>();
      slices.add(new SliceInfo(new SourceName("A"),1L));
      slices.add(new SliceInfo(new SourceName("B"),2L));
      slices.add(new SliceInfo(new SourceName("C"),3L));
      request.setSlices(slices);
      
      return request;
   }
   
   public Response createResponse()
   {
      IntegrityVerificationResponse response = new IntegrityVerificationResponse();
      
      List<SliceInfo> slices = new ArrayList<SliceInfo>();
      slices.add(new SliceInfo(new SourceName("A"),1L));
      slices.add(new SliceInfo(new SourceName("B"),2L));
      slices.add(new SliceInfo(new SourceName("C"),3L));
      response.setCorruptedSlices(slices);
      
      return response;
   }
}