package org.cleversafe.protocol;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

import org.cleversafe.layer.protocol.CreateStoreRequest;
import org.cleversafe.layer.protocol.CreateStoreResponse;
import org.cleversafe.layer.protocol.Request;
import org.cleversafe.layer.protocol.Response;
import org.cleversafe.vault.FileVaultACL;
import org.cleversafe.vault.VaultACL;
import org.junit.Before;

public class CreateStoreProtocolTest extends ProtocolVerificationTest
{
   final private byte[] requestBytes = {0, -54, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 0, 0, 10, 118, 97, 117, 108, 116, 45, 116, 121, 112, 101, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 2, 0, 10, 115, 116, 111, 114, 101, 45, 116, 121, 112, 101, 0, 36, 48, 48, 48, 48, 48, 48, 48, 48, 45, 48, 48, 48, 48, 45, 48, 48, 48, 55, 45, 48, 48, 48, 48, 45, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 98, 0, 0, 0, 5, 0, 2, 4, 6, 8, 0, 0, 0, 5, 1, 3, 5, 7, 9, 0, 0, 0, 2, 0, 5, 104, 101, 108, 108, 111, 0, 5, 119, 111, 114, 108, 100, 0, 4, 103, 111, 111, 100, 0, 3, 98, 121, 101};
   final private byte[] responseBytes  = {0, -54, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 0, 0, 0};
   
   @Before
   public void setup()
   {
      super.registerRequestBytes(requestBytes);
      super.registerResponseBytes(responseBytes);
   }
   
   public Request createRequest()
   {
      CreateStoreRequest request = new CreateStoreRequest();
      
      request.setMaxSliceSize(1L);
      
      Map<String,String> options = new HashMap<String,String>();
      options.put("hello", "world");
      options.put("good", "bye");
      request.setOptions(options);
      
      request.setSliceStoreSize(2L);
      
      request.setSliceStoreType("store-type");
      
      VaultACL vaultACL = new FileVaultACL();
      request.setVaultACL(vaultACL);
      
      byte[] vaultACLBytes = {0, 2, 4, 6, 8};
      request.setVaultACLBytes(vaultACLBytes);
      
      byte[] vaultDescriptorBytes = {1, 3, 5, 7, 9};
      request.setVaultDescriptorBytes(vaultDescriptorBytes);
      
      request.setVaultID(new UUID(7L, 11L));
      
      request.setVaultType("vault-type");
      
      return request;
   }
   
   public Response createResponse()
   {
      CreateStoreResponse response = new CreateStoreResponse();
      
      return response;
   }
}