//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: wleggette
//
// Date: Aug 22, 2007
//---------------------

package org.cleversafe.vault.storage;

import org.cleversafe.vault.exceptions.VaultKeyGenerationException;
import org.cleversafe.vault.storage.asn1.KeyUsage;

public class VaultKeyInfo
{
   private int storageIndex;
   private String algorithm;
   private int size;
   // TODO: When there is a non-ASN1 key usage class, use that instead
   //       (we want storage-type agnostic key usage)
   private KeyUsage usage;
   
   public VaultKeyInfo() {}
   
   public VaultKeyInfo(int storageIndex, String algorithm, int size, KeyUsage usage)
   {
      super();
      this.storageIndex = storageIndex;
      this.algorithm = algorithm;
      this.size = size;
      this.usage = usage;
   }


   /**
    * Sets the algorithm by interpreting a transformation string.
    */
   public void setTransformation(String transformation)
   {
      if (transformation == null)
      {
         this.algorithm = null;
      }
      else if ( transformation.contains("with") )
      {
         // reads form like SHA1withDSA
         this.algorithm = transformation.split("with")[1];
      }
      else
      {
         // reads form like AES/CBC/PKCS5Padding
         this.algorithm = transformation.split("/")[0];
      }
      
   }
   

   public String getAlgorithm()
   {
      return algorithm;
   }
   public void setAlgorithm(String algorithm)
   {
      this.setTransformation(algorithm);
   }
   public int getSize()
   {
      return size;
   }
   public void setSize(int size)
   {
      this.size = size;
   }
   public KeyUsage getUsage()
   {
      return usage;
   }
   public void setUsage(KeyUsage usage)
   {
      this.usage = usage;
   }


   public int getStorageIndex()
   {
      return storageIndex;
   }


   public void setStorageIndex(int storageIndex)
   {
      this.storageIndex = storageIndex;
   }


   
   @Override
   public String toString()
   {
      StringBuilder sb = new StringBuilder();
      sb.append("(" + this.getClass().getName() + " ");
      sb.append("index=" + this.storageIndex + " ");
      sb.append("algorithm=" + this.algorithm + " ");
      sb.append("size=" + this.size + " ");
      sb.append("usage=" + this.usage + ")");
      return sb.toString();
   }


   @Override
   public int hashCode()
   {
      final int prime = 31;
      int result = 1;
      result = prime * result + ((algorithm == null) ? 0 : algorithm.hashCode());
      result = prime * result + size;
      result = prime * result + storageIndex;
      result = prime * result + ((usage == null) ? 0 : usage.hashCode());
      return result;
   }


   @Override
   public boolean equals(Object obj)
   {
      if (this == obj)
         return true;
      if (obj == null)
         return false;
      if (getClass() != obj.getClass())
         return false;
      final VaultKeyInfo other = (VaultKeyInfo) obj;
      if (algorithm == null)
      {
         if (other.algorithm != null)
            return false;
      }
      else if (!algorithm.equals(other.algorithm))
         return false;
      if (size != other.size)
         return false;
      if (storageIndex != other.storageIndex)
         return false;
      if (usage == null)
      {
         if (other.usage != null)
            return false;
      }
      else if (!usage.equals(other.usage))
         return false;
      return true;
   }
   
   
   
   
   
}

